/*
 * Decompiled with CFR 0.152.
 */
package randoop.operation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import randoop.ExceptionalExecution;
import randoop.ExecutionOutcome;
import randoop.operation.CallableOperation;
import randoop.operation.OperationParseException;
import randoop.operation.TypeArguments;
import randoop.operation.TypedClassOperation;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.reflection.ReflectionPredicate;
import randoop.sequence.Variable;
import randoop.types.ClassOrInterfaceType;
import randoop.types.Type;
import randoop.types.TypeTuple;
import randoop.util.ConstructorReflectionCode;
import randoop.util.ReflectionExecutor;
import randoop.util.Util;

public final class ConstructorCall
extends CallableOperation {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Constructor<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> constructor;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCodeCached = 0;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hashCodeComputed = false;

    public ConstructorCall(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Constructor<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> constructor) {
        if (constructor == null) {
            throw new IllegalArgumentException("constructor should not be null.");
        }
        this.constructor = constructor;
        this.constructor.setAccessible(true);
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Constructor<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> getConstructor() {
        return this.constructor;
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        Class<?>[] types;
        StringJoiner b = new StringJoiner(", ", this.constructor.getName() + "(", ")");
        for (Class<?> c : types = this.constructor.getParameterTypes()) {
            b.add(c.getName());
        }
        return b.toString();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getName() {
        return "<init>";
    }

    @Override
    public void appendCode(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type declaringType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple inputTypes, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type outputType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable> inputVars, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown StringBuilder b) {
        int i;
        assert (declaringType instanceof ClassOrInterfaceType) : "constructor must be member of class";
        ClassOrInterfaceType declaringClassType = (ClassOrInterfaceType)declaringType;
        boolean isMemberClass = declaringClassType.isMemberClass();
        assert (Util.implies(isMemberClass, !inputVars.isEmpty()));
        b.append(isMemberClass ? inputVars.get(0) + "." : "").append("new ").append(isMemberClass ? declaringClassType.getSimpleName() : declaringClassType.getFqName()).append("(");
        int n = i = isMemberClass ? 1 : 0;
        while (i < inputVars.size()) {
            if (i > (isMemberClass ? 1 : 0)) {
                b.append(", ");
            }
            if (!inputVars.get(i).getType().equals(inputTypes.get(i))) {
                b.append("(").append(inputTypes.get(i).getFqName()).append(")");
            }
            String param = this.getArgumentString(inputVars.get(i));
            b.append(param);
            ++i;
        }
        b.append(")");
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConstructorCall)) {
            return false;
        }
        ConstructorCall other = (ConstructorCall)o;
        return this.constructor.equals(other.constructor);
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        if (!this.hashCodeComputed) {
            this.hashCodeComputed = true;
            this.hashCodeCached = this.constructor.hashCode();
        }
        return this.hashCodeCached;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutionOutcome execute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] statementInput) {
        if (statementInput.length > 0 && statementInput[0] == null) {
            Class<?> declaringClass = this.constructor.getDeclaringClass();
            int mods = declaringClass.getModifiers() & Modifier.classModifiers();
            if (declaringClass.isMemberClass() && !Modifier.isStatic(mods)) {
                String message = "reflection call to " + this.constructor.getName() + " with null for superclass argument";
                return new ExceptionalExecution(new NullPointerException(message), 0L);
            }
        }
        ConstructorReflectionCode code = new ConstructorReflectionCode(this.constructor, statementInput);
        return ReflectionExecutor.executeReflectionCode(code);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toParsableString(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type declaringType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple inputTypes, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type outputType) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.constructor.getName()).append(".<init>(");
        Class<?>[] params = this.constructor.getParameterTypes();
        TypeArguments.getTypeArgumentString(sb, params);
        sb.append(")");
        return sb.toString();
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation parse(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String signature) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationParseException {
        Constructor<?> con;
        Object[] typeArguments;
        Type classType;
        if (signature == null) {
            throw new IllegalArgumentException("signature may not be null");
        }
        int openParPos = signature.indexOf(40);
        int closeParPos = signature.indexOf(41);
        String prefix = signature.substring(0, openParPos);
        int lastDotPos = prefix.lastIndexOf(46);
        assert (lastDotPos >= 0);
        String classname = prefix.substring(0, lastDotPos);
        String opname = prefix.substring(lastDotPos + 1);
        assert (opname.equals("<init>")) : "expected init, saw " + opname;
        String arguments = signature.substring(openParPos + 1, closeParPos);
        try {
            classType = Type.getTypeforFullyQualifiedName(classname);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            String msg = "Class " + classname + " is not on classpath while parsing \"" + signature + "\"";
            throw new OperationParseException(msg);
        }
        try {
            typeArguments = TypeArguments.getTypeArgumentsForString(arguments);
        }
        catch (OperationParseException e) {
            throw new OperationParseException(e.getMessage() + " while parsing \"" + signature + "\"");
        }
        try {
            con = classType.getRuntimeClass().getDeclaredConstructor((Class<?>[])typeArguments);
        }
        catch (NoSuchMethodException e) {
            String msg = "Constructor with arguments " + Arrays.toString(typeArguments) + " does not exist in " + classType + ": " + e;
            throw new OperationParseException(msg);
        }
        return TypedClassOperation.forConstructor(con);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isConstructorCall() {
        return true;
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Constructor<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> getReflectionObject() {
        return this.constructor;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean satisfies(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionPredicate reflectionPredicate) {
        return reflectionPredicate.test(this.constructor);
    }
}

