/*
 * Decompiled with CFR 0.152.
 */
package randoop.main;

import java.util.Arrays;
import randoop.Globals;
import randoop.main.CommandHandler;
import randoop.main.Main;
import randoop.main.RandoopUsageError;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.plumelib.options.Options;
import randoop.util.Util;

public class Help
extends CommandHandler {
    public Help() {
        super("help", "Displays a help message for a given command.", "help", "", "Displays a help message for a given command.", null, "None (for the general help message), or the name of a command (for command-specific help).", "A help message is printed to stdout.", "", new Options(Help.class));
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean handle(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] argsWithOptions) {
        Object[] args = null;
        try {
            args = this.foptions.parse(argsWithOptions);
            if (args.length > 1) {
                throw new Options.ArgException("Unrecognized arguments: " + Arrays.toString(args));
            }
        }
        catch (Options.ArgException ae) {
            System.out.println("Error while parsing command-line arguments: " + ae.getMessage());
            System.exit(1);
        }
        if (args.length == 0) {
            System.out.println("Randoop for Java version " + Globals.getRandoopVersion() + ".");
            System.out.println("Type `help' followed by a command name to see documentation.");
            System.out.println("Commands:");
            for (CommandHandler h2 : Main.handlers) {
                System.out.println(Util.hangingParagraph(h2.fcommand + " -- " + h2.fpitch, 70, 8));
            }
        } else {
            if (args.length != 1) {
                throw new RandoopUsageError(String.format("The `help' command must be followed by exactly one argument:%nthe command that you want help on.%nFor a list of commands, invoke Randoop with argument: help", new Object[0]));
            }
            Object command = args[0];
            for (CommandHandler h3 : Main.handlers) {
                if (!h3.fcommand.equals(command)) continue;
                h3.usageMessage(System.out);
                return true;
            }
            throw new RandoopUsageError("The command you asked help for was not recognized: " + (String)command);
        }
        System.out.println();
        return true;
    }
}

