/*
 * Decompiled with CFR 0.152.
 */
package randoop.generation;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import randoop.generation.InputSequenceSelector;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.sequence.ExecutableSequence;
import randoop.sequence.Sequence;
import randoop.util.Randomness;
import randoop.util.SimpleList;

public class OrienteeringSelection
extends InputSequenceSelector {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SequenceDetails> sequenceDetailsMap = new HashMap<Sequence, SequenceDetails>();
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Double> weightMap = new HashMap<Sequence, Double>();

    public OrienteeringSelection(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> seedSequences) {
        for (Sequence seedSequence : seedSequences) {
            this.createSequenceDetailsWithExecutionTime(seedSequence, 1L);
        }
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence selectInputSequence(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleList<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> candidates) {
        double totalWeight = this.computeTotalWeightForCandidates(candidates);
        Sequence selectedSequence = Randomness.randomMemberWeighted(candidates, this.weightMap, totalWeight);
        SequenceDetails sequenceDetails = this.sequenceDetailsMap.get(selectedSequence);
        sequenceDetails.incrementSelectionCount();
        this.weightMap.put(selectedSequence, sequenceDetails.getWeight());
        return selectedSequence;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown double computeTotalWeightForCandidates(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleList<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> candidates) {
        double totalWeight = 0.0;
        for (int i = 0; i < candidates.size(); ++i) {
            Sequence candidate = candidates.get(i);
            SequenceDetails details = this.sequenceDetailsMap.get(candidate);
            if (details == null) {
                this.createdExecutableSequence(new ExecutableSequence(candidate));
                details = this.sequenceDetailsMap.get(candidate);
            }
            totalWeight += details.getWeight();
        }
        return totalWeight;
    }

    @Override
    public void createdExecutableSequence(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSequence eSeq) {
        if (eSeq.exectime <= 0L) {
            eSeq.exectime = 1L;
        }
        this.createSequenceDetailsWithExecutionTime(eSeq.sequence, eSeq.exectime);
    }

    private void createSequenceDetailsWithExecutionTime(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence sequence, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown long executionTimeNanos) {
        SequenceDetails sequenceDetails = new SequenceDetails(sequence, executionTimeNanos);
        this.sequenceDetailsMap.put(sequence, sequenceDetails);
        this.weightMap.put(sequence, sequenceDetails.getWeight());
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown double methodSizeSquareRoot(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence sequence) {
        int methodSize = sequence.numMethodCalls();
        if (methodSize == 0) {
            return 1.0;
        }
        return Math.sqrt(methodSize);
    }

    private static class SequenceDetails {
        private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown double methodSizeSqrt;
        private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown long executionTimeNanos;
        private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int selectionCount;
        private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown double weight;

        SequenceDetails(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence sequence, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown long executionTimeNanos) {
            this(OrienteeringSelection.methodSizeSquareRoot(sequence), executionTimeNanos);
        }

        public SequenceDetails(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown double methodSizeSqrt, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown long executionTimeNanos) {
            this.methodSizeSqrt = methodSizeSqrt;
            this.executionTimeNanos = executionTimeNanos;
            this.selectionCount = 1;
            this.updateWeight();
        }

        public void incrementSelectionCount() {
            ++this.selectionCount;
            this.updateWeight();
        }

        public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown double getWeight() {
            return this.weight;
        }

        private void updateWeight() {
            this.weight = 1.0 / ((double)((long)this.selectionCount * this.executionTimeNanos) * this.methodSizeSqrt);
        }
    }
}

