/*
 * Decompiled with CFR 0.152.
 */
package randoop.generation;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import randoop.generation.OperationHistoryLogInterface;
import randoop.generation.OperationOutcome;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;

public class OperationHistoryLogger
implements OperationHistoryLogInterface {
    private final @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown PrintWriter writer;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown EnumMap<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationOutcome, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Integer>> operationMap;

    public OperationHistoryLogger(@UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown PrintWriter writer) {
        this.writer = writer;
        this.operationMap = new HashMap<TypedOperation, EnumMap<OperationOutcome, Integer>>();
    }

    @Override
    public void add(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation operation, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationOutcome outcome) {
        EnumMap outcomeMap = this.operationMap.computeIfAbsent(operation, __ -> new EnumMap(OperationOutcome.class));
        int count = outcomeMap.getOrDefault((Object)outcome, 0);
        outcomeMap.put(outcome, ++count);
    }

    @Override
    public void outputTable() {
        this.writer.format("%nOperation History:%n", new Object[0]);
        int maxNameLength = 0;
        for (TypedOperation operation : this.operationMap.keySet()) {
            int nameLength = operation.getSignatureString().length();
            maxNameLength = Math.max(nameLength, maxNameLength);
        }
        Map<OperationOutcome, String> formatMap = this.printHeader(maxNameLength);
        ArrayList<TypedOperation> keys = new ArrayList<TypedOperation>(this.operationMap.keySet());
        Collections.sort(keys);
        for (TypedOperation key : keys) {
            this.printRow(maxNameLength, formatMap, key, this.operationMap.get(key));
        }
        this.writer.flush();
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationOutcome, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> printHeader(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int firstColumnLength) {
        EnumMap<OperationOutcome, String> formatMap = new EnumMap<OperationOutcome, String>(OperationOutcome.class);
        this.writer.format("%-" + firstColumnLength + "s", "Operation");
        for (OperationOutcome outcome : OperationOutcome.values()) {
            this.writer.format("\t%" + outcome.name().length() + "s", new Object[]{outcome});
            formatMap.put(outcome, "\t%" + outcome.name().length() + "d");
        }
        this.writer.format("%n", new Object[0]);
        return formatMap;
    }

    private void printRow(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int firstColumnLength, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationOutcome, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> formatMap, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation operation, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown EnumMap<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationOutcome, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Integer> countMap) {
        this.writer.format("%-" + firstColumnLength + "s", operation.getSignatureString());
        for (OperationOutcome outcome : OperationOutcome.values()) {
            Integer count = countMap.getOrDefault((Object)outcome, 0);
            this.writer.format(formatMap.get((Object)outcome), count);
        }
        this.writer.format("%n", new Object[0]);
    }
}

