/*
 * Decompiled with CFR 0.152.
 */
package randoop.generation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import randoop.generation.GrtNumericFuzzer;
import randoop.generation.GrtStringFuzzer;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.sequence.Sequence;
import randoop.types.Type;

public abstract class GrtFuzzer {
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GrtFuzzer> FUZZERS = Arrays.asList(GrtNumericFuzzer.getInstance(), GrtStringFuzzer.getInstance());
    protected static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Integer, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence.RelativeNegativeIndex>> NEGATIVE_INDEX_CACHE = new HashMap<Integer, List<Sequence.RelativeNegativeIndex>>();

    public static @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GrtFuzzer getFuzzer(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type type) {
        for (GrtFuzzer f : FUZZERS) {
            if (!f.canFuzz(type)) continue;
            return f;
        }
        return null;
    }

    protected static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence.RelativeNegativeIndex> getRelativeNegativeIndices(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int size) {
        return NEGATIVE_INDEX_CACHE.computeIfAbsent(size, s2 -> {
            ArrayList<Sequence.RelativeNegativeIndex> list = new ArrayList<Sequence.RelativeNegativeIndex>((int)s2);
            for (int i = -s2.intValue(); i < 0; ++i) {
                list.add(new Sequence.RelativeNegativeIndex(i));
            }
            return Collections.unmodifiableList(list);
        });
    }

    public abstract @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean canFuzz(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type var1);

    public abstract @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence fuzz(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence var1);
}

