/*
 * Decompiled with CFR 0.152.
 */
package randoop.generation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import randoop.DummyVisitor;
import randoop.Globals;
import randoop.NormalExecution;
import randoop.SubTypeSet;
import randoop.generation.AbstractGenerator;
import randoop.generation.Bloodhound;
import randoop.generation.ComponentManager;
import randoop.generation.GrtFuzzer;
import randoop.generation.HelperSequenceCreator;
import randoop.generation.IStopper;
import randoop.generation.InputSequenceSelector;
import randoop.generation.InputsAndSuccessFlag;
import randoop.generation.OperationOutcome;
import randoop.generation.OrienteeringSelection;
import randoop.generation.RandoopGenerationError;
import randoop.generation.SmallTestsSequenceSelection;
import randoop.generation.TypedOperationSelector;
import randoop.generation.UniformRandomMethodSelection;
import randoop.generation.UniformRandomSequenceSelection;
import randoop.main.GenInputsAbstract;
import randoop.main.RandoopBug;
import randoop.operation.NonreceiverTerm;
import randoop.operation.TypedClassOperation;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.CollectionsPlume;
import randoop.org.plumelib.util.StringsPlume;
import randoop.org.plumelib.util.SystemPlume;
import randoop.reflection.RandoopInstantiationError;
import randoop.reflection.TypeInstantiator;
import randoop.sequence.ExecutableSequence;
import randoop.sequence.Sequence;
import randoop.sequence.Statement;
import randoop.sequence.Value;
import randoop.sequence.Variable;
import randoop.test.DummyCheckGenerator;
import randoop.types.ClassOrInterfaceType;
import randoop.types.InstantiatedType;
import randoop.types.JDKTypes;
import randoop.types.JavaTypes;
import randoop.types.Type;
import randoop.types.TypeTuple;
import randoop.util.ListOfLists;
import randoop.util.Log;
import randoop.util.MultiMap;
import randoop.util.Randomness;
import randoop.util.SimpleArrayList;
import randoop.util.SimpleList;

public class ForwardGenerator
extends AbstractGenerator {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown LinkedHashSet<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> allSequences = new LinkedHashSet();
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation> sideEffectFreeMethods;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> allsequencesAsCode = new ArrayList<String>();
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> allsequencesAsList = new ArrayList<Sequence>();
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeInstantiator instantiator;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown InputSequenceSelector inputSequenceSelector;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperationSelector operationSelector;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object> runtimePrimitivesSeen = new LinkedHashSet<Object>();

    public ForwardGenerator(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation> operations, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation> sideEffectFreeMethods, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GenInputsAbstract.Limits limits, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ComponentManager componentManager, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType> classesUnderTest) {
        this(operations, sideEffectFreeMethods, limits, componentManager, null, classesUnderTest);
    }

    public ForwardGenerator(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation> operations, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation> sideEffectFreeMethods, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GenInputsAbstract.Limits limits, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ComponentManager componentManager, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IStopper stopper, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType> classesUnderTest) {
        super(operations, limits, componentManager, stopper);
        this.sideEffectFreeMethods = sideEffectFreeMethods;
        this.instantiator = componentManager.getTypeInstantiator();
        this.initializeRuntimePrimitivesSeen();
        switch (GenInputsAbstract.method_selection) {
            case UNIFORM: {
                this.operationSelector = new UniformRandomMethodSelection(operations);
                break;
            }
            case BLOODHOUND: {
                this.operationSelector = new Bloodhound(operations, classesUnderTest);
                break;
            }
            default: {
                throw new Error("Unhandled method_selection: " + (Object)((Object)GenInputsAbstract.method_selection));
            }
        }
        switch (GenInputsAbstract.input_selection) {
            case ORIENTEERING: {
                this.inputSequenceSelector = new OrienteeringSelection(componentManager.getAllGeneratedSequences());
                break;
            }
            case SMALL_TESTS: {
                this.inputSequenceSelector = new SmallTestsSequenceSelection();
                break;
            }
            case UNIFORM: {
                this.inputSequenceSelector = new UniformRandomSequenceSelection();
                break;
            }
            default: {
                throw new Error("Unhandled --input-selection: " + (Object)((Object)GenInputsAbstract.input_selection));
            }
        }
    }

    @Override
    public void newRegressionTestHook(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence sequence) {
        this.operationSelector.newRegressionTestHook(sequence);
    }

    private void initializeRuntimePrimitivesSeen() {
        for (Sequence s2 : this.componentManager.getAllPrimitiveSequences()) {
            ExecutableSequence es = new ExecutableSequence(s2);
            es.execute(new DummyVisitor(), new DummyCheckGenerator());
            NormalExecution e = (NormalExecution)es.getResult(0);
            Object runtimeValue = e.getRuntimeValue();
            this.runtimePrimitivesSeen.add(runtimeValue);
        }
    }

    @Override
    public @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSequence step() {
        ExecutableSequence eSeq;
        int nanoPerMilli = 1000000;
        long nanoPerOne = 1000000000L;
        long timeWarningLimitNanos = 1000000000L;
        long startTimeNanos = System.nanoTime();
        if (this.componentManager.numGeneratedSequences() % GenInputsAbstract.clear == 0) {
            this.componentManager.clearGeneratedSequences();
        }
        if (SystemPlume.usedMemory(false) > GenInputsAbstract.clear_memory && SystemPlume.usedMemory(true) > GenInputsAbstract.clear_memory) {
            this.componentManager.clearGeneratedSequences();
        }
        if ((eSeq = this.createNewUniqueSequence()) == null) {
            long gentimeNanos = System.nanoTime() - startTimeNanos;
            if (gentimeNanos > 1000000000L) {
                System.out.printf("Long generation time %d msec for null sequence.%n", gentimeNanos / 1000000L);
            }
            return null;
        }
        if (GenInputsAbstract.dontexecute) {
            this.componentManager.addGeneratedSequence(eSeq.sequence);
            long gentimeNanos = System.nanoTime() - startTimeNanos;
            if (gentimeNanos > 1000000000L) {
                System.out.printf("Long generation time %d msec for%n", gentimeNanos / 1000000L);
                System.out.println(eSeq.sequence);
            }
            return null;
        }
        this.setCurrentSequence(eSeq.sequence);
        long gentimeNanos1 = System.nanoTime() - startTimeNanos;
        eSeq.execute(this.executionVisitor, this.checkGenerator);
        startTimeNanos = System.nanoTime();
        this.inputSequenceSelector.createdExecutableSequence(eSeq);
        this.determineActiveIndices(eSeq);
        if (eSeq.sequence.hasActiveFlags()) {
            this.componentManager.addGeneratedSequence(eSeq.sequence);
        }
        long gentimeNanos2 = System.nanoTime() - startTimeNanos;
        eSeq.gentimeNanos = gentimeNanos1 + gentimeNanos2;
        if (eSeq.gentimeNanos > 1000000000L) {
            System.out.printf("Long generation time %d msec (= %d + %d) for%n", eSeq.gentimeNanos / 1000000L, gentimeNanos1 / 1000000L, gentimeNanos2 / 1000000L);
            System.out.println(eSeq.sequence);
        }
        if (eSeq.exectime > 10000000000L) {
            System.out.printf("Long execution time %d sec for%n", eSeq.exectime / 1000000000L);
            System.out.println(eSeq.sequence);
        }
        return eSeq;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> getAllSequences() {
        return this.allSequences;
    }

    private void determineActiveIndices(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSequence seq) {
        if (seq.hasNonExecutedStatements()) {
            Log.logPrintf("Sequence has non-executed statements: excluding from extension pool.%n", new Object[0]);
            Log.logPrintf("Non-executed statement: %s%n", seq.statementToCodeString(seq.getNonExecutedIndex()));
            seq.sequence.clearAllActiveFlags();
            return;
        }
        if (seq.hasFailure()) {
            Log.logPrintf("Sequence has failure: excluding from extension pool.%n", new Object[0]);
            Log.logPrintf("Failing sequence: %s%n", seq.toCodeString());
            seq.sequence.clearAllActiveFlags();
            return;
        }
        if (seq.hasInvalidBehavior()) {
            Log.logPrintf("Sequence has invalid behavior (%s): excluding from extension pool.%n", seq.getChecks());
            Log.logPrintf("Invalid sequence: %s%n", seq.toCodeString());
            seq.sequence.clearAllActiveFlags();
            return;
        }
        if (!seq.isNormalExecution()) {
            int i = seq.getNonNormalExecutionIndex();
            Log.logPrintf("Excluding from extension pool due to exception or failure in statement %d%n", i);
            Log.logPrintf("  Statement: %s%n", seq.statementToCodeString(i));
            Log.logPrintf("  Result: %s%n", seq.getResult(i));
            seq.sequence.clearAllActiveFlags();
            return;
        }
        if (!Value.lastValueSizeOk(seq)) {
            int i = seq.sequence.statements.size() - 1;
            Log.logPrintf("Excluding from extension pool due to value too large in last statement %d%n", i);
            Log.logPrintf("  Statement: %s%n", seq.statementToCodeString(i));
            seq.sequence.clearAllActiveFlags();
            return;
        }
        for (int i = 0; i < seq.sequence.size(); ++i) {
            Class<?> objectClass;
            NormalExecution e = (NormalExecution)seq.getResult(i);
            Object runtimeValue = e.getRuntimeValue();
            if (runtimeValue == null) {
                Log.logPrintf("Making index " + i + " inactive (value is null)%n", new Object[0]);
                seq.sequence.clearActiveFlag(i);
                continue;
            }
            Sequence stmts = seq.sequence;
            Statement stmt = stmts.statements.get(i);
            boolean isSideEffectFree = stmt.isMethodCall() && this.sideEffectFreeMethods.contains(stmt.getOperation());
            Log.logPrintf("isSideEffectFree => %s for %s%n", isSideEffectFree, stmt);
            if (isSideEffectFree) {
                List<Integer> inputVars = stmts.getInputsAsAbsoluteIndices(i);
                for (Integer inputIndex : inputVars) {
                    seq.sequence.clearActiveFlag(inputIndex);
                }
            }
            if ((objectClass = runtimeValue.getClass()).isArray() && !Value.arrayLengthOk(runtimeValue)) {
                seq.sequence.clearActiveFlag(i);
                continue;
            }
            if (NonreceiverTerm.isNonreceiverType(objectClass) && !objectClass.equals(Class.class)) {
                boolean tooLongString;
                Log.logPrintf("Making index " + i + " inactive (value is a primitive)%n", new Object[0]);
                seq.sequence.clearActiveFlag(i);
                boolean looksLikeObjToString = runtimeValue instanceof String && Value.looksLikeObjectToString((String)runtimeValue);
                boolean bl = tooLongString = runtimeValue instanceof String && !Value.escapedStringLengthOk((String)runtimeValue);
                if (runtimeValue instanceof Double && Double.isNaN((Double)runtimeValue)) {
                    runtimeValue = Double.NaN;
                }
                if (runtimeValue instanceof Float && Float.isNaN(((Float)runtimeValue).floatValue())) {
                    runtimeValue = Float.valueOf(Float.NaN);
                }
                if (looksLikeObjToString || tooLongString || !this.runtimePrimitivesSeen.add(runtimeValue)) continue;
                this.componentManager.addGeneratedSequence(Sequence.createSequenceForPrimitive(runtimeValue));
                continue;
            }
            Log.logPrintf("Making index " + i + " active.%n", new Object[0]);
        }
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSequence createNewUniqueSequence() {
        InputsAndSuccessFlag inputs;
        Log.logPrintf("-------------------------------------------%n", new Object[0]);
        if (Log.isLoggingOn()) {
            Log.logPrintln("Memory used: " + StringsPlume.abbreviateNumber(SystemPlume.usedMemory(false)));
        }
        if (this.operations.isEmpty()) {
            return null;
        }
        TypedOperation operation = this.operationSelector.selectOperation();
        Log.logPrintf("Selected operation: %s%n", operation);
        if (operation.isGeneric() || operation.hasWildcardTypes()) {
            try {
                operation = this.instantiator.instantiate((TypedClassOperation)operation);
            }
            catch (Throwable e) {
                if (GenInputsAbstract.fail_on_generation_error) {
                    if (operation.isMethodCall() || operation.isConstructorCall()) {
                        String opName = operation.getOperation().getReflectionObject().toString();
                        throw new RandoopInstantiationError(opName, e);
                    }
                }
                this.operationHistory.add(operation, OperationOutcome.SEQUENCE_DISCARDED);
                Log.logPrintf("Sequence discarded: Instantiation error for operation%n %s%n", operation);
                Log.logStackTrace(e);
                System.out.printf("Instantiation error for operation%n %s%n", operation);
                return null;
            }
            if (operation == null) {
                Log.logPrintf("Failed to instantiate generic operation%n", operation);
                return null;
            }
        }
        try {
            inputs = this.selectInputs(operation);
        }
        catch (Throwable e) {
            if (GenInputsAbstract.fail_on_generation_error) {
                throw new RandoopGenerationError(operation, e);
            }
            this.operationHistory.add(operation, OperationOutcome.SEQUENCE_DISCARDED);
            Log.logPrintf("Sequence discarded: Error selecting inputs for operation: %s%n", operation);
            Log.logStackTrace(e);
            System.out.println("Error selecting inputs for operation: " + operation);
            e.printStackTrace(System.out);
            return null;
        }
        if (!inputs.success) {
            this.operationHistory.add(operation, OperationOutcome.NO_INPUTS_FOUND);
            Log.logPrintf("Failed to find inputs for operation: %s%n", operation);
            return null;
        }
        Sequence concatSeq = Sequence.concatenate(inputs.sequences);
        List<Variable> inputVars = CollectionsPlume.mapList(concatSeq::getVariable, inputs.indices);
        Sequence newSequence = concatSeq.extend(operation, inputVars);
        if (GenInputsAbstract.repeat_heuristic && Randomness.nextRandomInt(10) == 0) {
            int times = Randomness.nextRandomInt(100);
            newSequence = this.repeat(newSequence, operation, times);
            Log.logPrintf("repeat-heuristic>>> %s %s%n", times, newSequence.toCodeString());
        }
        if (operation.getInputTypes().isEmpty()) {
            this.operationHistory.add(operation, OperationOutcome.REMOVED);
            this.operations.remove(operation);
        }
        if (newSequence.size() > GenInputsAbstract.maxsize) {
            this.operationHistory.add(operation, OperationOutcome.SEQUENCE_DISCARDED);
            Log.logPrintf("Sequence discarded: size %d exceeds maximum allowed size %d%n", newSequence.size(), GenInputsAbstract.maxsize);
            return null;
        }
        this.randoopConsistencyTests(newSequence);
        if (this.allSequences.contains(newSequence)) {
            this.operationHistory.add(operation, OperationOutcome.SEQUENCE_DISCARDED);
            Log.logPrintf("Sequence discarded: the same sequence was previously created.%n", new Object[0]);
            return null;
        }
        this.allSequences.add(newSequence);
        this.randoopConsistencyTest2(newSequence);
        Log.logPrintf("Successfully created new unique sequence:%n%s%n", newSequence.toString());
        ExecutableSequence result = new ExecutableSequence(newSequence);
        result.componentSequences = inputs.sequences;
        return result;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence repeat(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence seq, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation operation, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int times) {
        Sequence retseq = new Sequence(seq.statements);
        for (int i = 0; i < times; ++i) {
            List<Variable> inputs = retseq.getInputs(retseq.size() - 1);
            ArrayList<Integer> vil = new ArrayList<Integer>(inputs.size());
            for (Variable v : inputs) {
                if (v.getType().equals(JavaTypes.INT_TYPE)) {
                    int randint = Randomness.nextRandomInt(100);
                    retseq = retseq.extend(TypedOperation.createPrimitiveInitialization(JavaTypes.INT_TYPE, randint), new Variable[0]);
                    vil.add(retseq.size() - 1);
                    continue;
                }
                vil.add(v.getDeclIndex());
            }
            Sequence currentRetseq = retseq;
            List<Variable> vl = CollectionsPlume.mapList(currentRetseq::getVariable, vil);
            retseq = retseq.extend(operation, vl);
        }
        return retseq;
    }

    private void randoopConsistencyTest2(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence newSequence) {
        if (GenInputsAbstract.debug_checks) {
            this.allsequencesAsCode.add(newSequence.toCodeString());
            this.allsequencesAsList.add(newSequence);
        }
    }

    private void randoopConsistencyTests(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence newSequence) {
        String code;
        int codeIndex;
        if (!GenInputsAbstract.debug_checks) {
            return;
        }
        int sequenceIndex = this.allsequencesAsList.indexOf(newSequence);
        if (sequenceIndex != (codeIndex = this.allsequencesAsCode.indexOf(code = newSequence.toCodeString()))) {
            StringJoiner msg = new StringJoiner(System.lineSeparator());
            msg.add(String.format("Different search results for sequence (index=%d) and its code (index=%d).", sequenceIndex, codeIndex));
            msg.add("new component:");
            msg.add(newSequence.toString());
            msg.add("new component's code:");
            msg.add(code);
            if (sequenceIndex != -1) {
                msg.add("stored code corresponding to found sequence:");
                msg.add(this.allsequencesAsList.get(sequenceIndex).toString());
            }
            if (codeIndex != -1) {
                msg.add("stored sequence corresponding to found code:");
                msg.add(this.allsequencesAsCode.get(codeIndex));
            }
            throw new IllegalStateException(msg.toString());
        }
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown InputsAndSuccessFlag selectInputs(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation operation) {
        TypeTuple inputTypes = operation.getInputTypes();
        Log.logPrintf("selectInputs:  inputTypes=%s%n", inputTypes);
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        int totStatements = 0;
        ArrayList<Integer> inputVars = new ArrayList<Integer>();
        SubTypeSet types = new SubTypeSet(false);
        MultiMap<Type, Integer> typesToVars = new MultiMap<Type, Integer>(inputTypes.size());
        for (int i = 0; i < inputTypes.size(); ++i) {
            GrtFuzzer fuzzer;
            SimpleList<Sequence> candidates;
            boolean isReceiver;
            Type inputType = inputTypes.get(i);
            boolean bl = isReceiver = i == 0 && operation.isMessage() && !operation.isStatic();
            if (GenInputsAbstract.alias_ratio != 0.0 && Randomness.weightedCoinFlip(GenInputsAbstract.alias_ratio)) {
                Set<Type> matches = types.getMatches(inputType);
                ArrayList candidateVars = new ArrayList(matches.size());
                for (Type match : matches) {
                    assert (typesToVars.keySet().contains(match));
                    candidateVars.add(new SimpleArrayList(typesToVars.getValues(match)));
                }
                ListOfLists candidateVars2 = new ListOfLists(candidateVars);
                if (!candidateVars2.isEmpty()) {
                    int randVarIdx = Randomness.nextRandomInt(candidateVars2.size());
                    Integer randVar = (Integer)candidateVars2.get(randVarIdx);
                    inputVars.add(randVar);
                    continue;
                }
            }
            if (!isReceiver && !GenInputsAbstract.forbid_null && GenInputsAbstract.null_ratio != 0.0 && Randomness.weightedCoinFlip(GenInputsAbstract.null_ratio)) {
                Log.logPrintf("Using null as input.%n", new Object[0]);
                TypedOperation st = TypedOperation.createNullOrZeroInitializationForType(inputType);
                Sequence seq = new Sequence().extend(st, Collections.emptyList());
                inputVars.add(totStatements);
                sequences.add(seq);
                assert (seq.size() == 1);
                ++totStatements;
                continue;
            }
            if (inputType.isArray()) {
                Log.logPrintf("Array creation heuristic: will create helper array of type %s%n", inputType);
                SimpleList<Sequence> l1 = this.componentManager.getSequencesForType(operation, i, isReceiver);
                SimpleList<Sequence> l2 = HelperSequenceCreator.createArraySequence(this.componentManager, inputType);
                candidates = new ListOfLists<Sequence>(l1, l2);
                Log.logPrintf("Array creation heuristic: " + candidates.size() + " candidates%n", new Object[0]);
            } else if (inputType.isParameterized() && ((InstantiatedType)inputType).getGenericClassType().isSubtypeOf(JDKTypes.COLLECTION_TYPE)) {
                InstantiatedType classType = (InstantiatedType)inputType;
                SimpleList<Sequence> l1 = this.componentManager.getSequencesForType(operation, i, isReceiver);
                Log.logPrintf("Collection creation heuristic: will create helper of type %s%n", classType);
                SimpleArrayList<Sequence> l2 = new SimpleArrayList<Sequence>(1);
                Sequence creationSequence = HelperSequenceCreator.createCollection(this.componentManager, classType);
                if (creationSequence != null) {
                    l2.add(creationSequence);
                }
                candidates = new ListOfLists<Sequence>(l1, l2);
            } else {
                Log.logPrintf("Will query component set for objects of type %s%n", inputType);
                candidates = this.componentManager.getSequencesForType(operation, i, isReceiver);
            }
            assert (candidates != null);
            Log.logPrintf("number of candidate components: %s%n", candidates.size());
            if (candidates.isEmpty()) {
                if (isReceiver) {
                    Log.logPrintf("No sequences of receiver type.%n", new Object[0]);
                    return new InputsAndSuccessFlag(false, null, null);
                }
                if (GenInputsAbstract.forbid_null) {
                    Log.logPrintf("No sequences of type, and forbid-null option is true. Failed to create new sequence.%n", new Object[0]);
                    return new InputsAndSuccessFlag(false, null, null);
                }
                Log.logPrintf("Found no sequences of required type; will use null as " + i + "-th input%n", new Object[0]);
                TypedOperation st = TypedOperation.createNullOrZeroInitializationForType(inputType);
                Sequence seq = new Sequence().extend(st, Collections.emptyList());
                inputVars.add(totStatements);
                sequences.add(seq);
                assert (seq.size() == 1);
                ++totStatements;
                continue;
            }
            VarAndSeq varAndSeq = this.randomVariable(candidates, inputType, isReceiver);
            Variable randomVariable = varAndSeq.var;
            Sequence chosenSeq = varAndSeq.seq;
            int fuzzingSizeChange = 0;
            boolean grtFuzz = GenInputsAbstract.grt_fuzzing;
            if (grtFuzz && (fuzzer = GrtFuzzer.getFuzzer(inputType)) != null) {
                int prevSize = chosenSeq.size();
                chosenSeq = fuzzer.fuzz(chosenSeq);
                fuzzingSizeChange = chosenSeq.size() - prevSize;
            }
            if (GenInputsAbstract.alias_ratio != 0.0) {
                for (int j = 0; j < chosenSeq.size(); ++j) {
                    Statement stk = chosenSeq.getStatement(j);
                    if (stk.isNonreceivingInitialization()) continue;
                    Type outType = stk.getOutputType();
                    types.add(outType);
                    typesToVars.add(outType, totStatements + j);
                }
            }
            inputVars.add(totStatements + randomVariable.index + fuzzingSizeChange);
            sequences.add(chosenSeq);
            totStatements += chosenSeq.size();
        }
        return new InputsAndSuccessFlag(true, sequences, inputVars);
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown VarAndSeq randomVariable(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleList<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> candidates, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type inputType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isReceiver) {
        for (int i = 0; i < 10; ++i) {
            Sequence chosenSeq = this.inputSequenceSelector.selectInputSequence(candidates);
            Log.logPrintf("chosenSeq: %s%n", chosenSeq);
            Variable randomVariable = chosenSeq.randomVariableForTypeLastStatement(inputType, isReceiver);
            if (randomVariable == null) continue;
            if (isReceiver && (chosenSeq.getCreatingStatement(randomVariable).isNonreceivingInitialization() || randomVariable.getType().isPrimitive())) {
                System.out.println();
                System.out.println("Selected null or a primitive as the receiver for a method call.");
                System.out.printf("  isReceiver = %s%n", isReceiver);
                System.out.printf("  randomVariable = %s%n", randomVariable);
                System.out.printf("    getType() = %s%n", randomVariable.getType());
                System.out.printf("    isPrimitive = %s%n", randomVariable.getType().isPrimitive());
                System.out.printf("  chosenSeq = {%n%s}%n", chosenSeq);
                System.out.printf("    getCreatingStatement = %s%n", chosenSeq.getCreatingStatement(randomVariable));
                System.out.printf("    isNonreceivingInitialization = %s%n", chosenSeq.getCreatingStatement(randomVariable).isNonreceivingInitialization());
                continue;
            }
            return new VarAndSeq(randomVariable, chosenSeq);
        }
        assert (isReceiver);
        int numCandidates = candidates.size();
        ArrayList<VarAndSeq> validResults = new ArrayList<VarAndSeq>(numCandidates);
        for (int i = 0; i < numCandidates; ++i) {
            Sequence s2 = candidates.get(i);
            Variable randomVariable = s2.randomVariableForTypeLastStatement(inputType, isReceiver);
            validResults.add(new VarAndSeq(randomVariable, s2));
        }
        if (validResults.isEmpty()) {
            throw new RandoopBug(String.format("In randomVariable, no candidates for %svariable with input type %s", isReceiver ? "receiver " : "", inputType));
        }
        return (VarAndSeq)Randomness.randomMember(validResults);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int numGeneratedSequences() {
        return this.allSequences.size();
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return "ForwardGenerator(" + String.join((CharSequence)(";" + Globals.lineSep + "    "), String.join((CharSequence)", ", "steps: " + this.num_steps, "null steps: " + this.null_steps, "num_sequences_generated: " + this.num_sequences_generated), String.join((CharSequence)", ", "allSequences: " + this.allSequences.size(), "regresson seqs: " + this.outRegressionSeqs.size(), "error seqs: " + this.outErrorSeqs.size() + "=" + this.num_failing_sequences + "=" + this.getErrorTestSequences().size(), "invalid seqs: " + this.invalidSequenceCount, "subsumed_sequences: " + this.subsumed_sequences.size(), "num_failed_output_test: " + this.num_failed_output_test), String.join((CharSequence)", ", "sideEffectFreeMethods: " + this.sideEffectFreeMethods.size(), "runtimePrimitivesSeen: " + this.runtimePrimitivesSeen.size())) + ")";
    }

    private static class VarAndSeq {
        final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable var;
        final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence seq;

        VarAndSeq(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable var, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence seq) {
            this.var = var;
            this.seq = seq;
        }
    }
}

