/*
 * Decompiled with CFR 0.152.
 */
package randoop.generation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jacoco.agent.rt.RT;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.ExecutionDataReader;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfo;
import randoop.main.GenInputsAbstract;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.BinaryName;
import randoop.org.checkerframework.checker.signature.qual.InternalForm;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.plumelib.reflection.Signatures;
import randoop.types.ClassOrInterfaceType;

public class CoverageTracker {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutionDataStore executionData = new ExecutionDataStore();
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Double> branchCoverageMap = new HashMap<String, Double>();
    protected final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@BinaryName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String> classesUnderTest = new HashSet<String>();

    public CoverageTracker(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType> classInterfaceTypes) {
        for (ClassOrInterfaceType classOrInterfaceType : classInterfaceTypes) {
            @BinaryName String bn = classOrInterfaceType.getRuntimeClass().getName();
            if (GenInputsAbstract.bloodhound_logging) {
                System.out.println("classUnderTest: " + bn);
            }
            this.classesUnderTest.add(bn);
        }
    }

    private void collectCoverageInformation() {
        try {
            ByteArrayInputStream execDataStream;
            try {
                execDataStream = new ByteArrayInputStream(RT.getAgent().getExecutionData(false));
            }
            catch (IllegalStateException e) {
                System.out.println("If the error notes: 'JaCoCo agent not started', the issue is likely that the Jacoco agent is not included as a Java agent.");
                System.out.println("To do so, add '-Xbootclasspath/a:/path/to/jacocoagent.jar -javaagent:/path/to/jacocoagent.jar' to the command line argument.");
                throw e;
            }
            ExecutionDataReader reader = new ExecutionDataReader(execDataStream);
            reader.setSessionInfoVisitor(DummySessionInfoVisitor.instance);
            reader.setExecutionDataVisitor(new IExecutionDataVisitor(){

                @Override
                public void visitClassExecution(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutionData data) {
                    CoverageTracker.this.executionData.put(data);
                }
            });
            reader.read();
            ((InputStream)execDataStream).close();
        }
        catch (IOException e) {
            System.err.println("Error in Coverage Tracker in collecting coverage information.");
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public void updateBranchCoverageMap() {
        this.collectCoverageInformation();
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(this.executionData, coverageBuilder);
        for (String className : this.classesUnderTest) {
            String resource = this.getResourceFromClassName(className);
            try {
                InputStream original = this.getClass().getResourceAsStream(resource);
                Object object = null;
                try {
                    analyzer.analyzeClass(original, className);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (original == null) continue;
                    if (object != null) {
                        try {
                            original.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        continue;
                    }
                    original.close();
                }
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
        ArrayList<IClassCoverage> classes = new ArrayList<IClassCoverage>(coverageBuilder.getClasses());
        classes.sort(Comparator.comparing(Object::toString));
        for (IClassCoverage cc : classes) {
            ArrayList<IMethodCoverage> methods = new ArrayList<IMethodCoverage>(cc.getMethods());
            methods.sort(Comparator.comparing(Object::toString));
            for (IMethodCoverage cm : methods) {
                double uncovRatio;
                @InternalForm String ifClassName = cc.getName();
                String fqMethodName = Signatures.internalFormToFullyQualified(ifClassName) + "." + cm.getName();
                if (GenInputsAbstract.bloodhound_logging) {
                    System.out.println(fqMethodName + " - " + cm.getBranchCounter().getMissedRatio());
                }
                uncovRatio = Double.isNaN(uncovRatio = cm.getBranchCounter().getMissedRatio()) ? 0.0 : uncovRatio;
                this.branchCoverageMap.put(fqMethodName, uncovRatio);
            }
        }
        if (GenInputsAbstract.bloodhound_logging) {
            System.out.println("---------------------------");
        }
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getResourceFromClassName(@BinaryName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String className) {
        return '/' + className.replace('.', '/') + ".class";
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Double getBranchCoverageForMethod(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String methodName) {
        return this.branchCoverageMap.get(methodName);
    }

    private static class DummySessionInfoVisitor
    implements ISessionInfoVisitor {
        public static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown DummySessionInfoVisitor instance = new DummySessionInfoVisitor();

        private DummySessionInfoVisitor() {
        }

        @Override
        public void visitSessionInfo(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SessionInfo info) {
        }
    }
}

