/*
 * Decompiled with CFR 0.152.
 */
package randoop.generation;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import randoop.DummyVisitor;
import randoop.ExecutionVisitor;
import randoop.MultiVisitor;
import randoop.generation.ComponentManager;
import randoop.generation.DefaultOperationHistoryLogger;
import randoop.generation.IStopper;
import randoop.generation.OperationHistoryLogInterface;
import randoop.generation.OperationOutcome;
import randoop.main.GenInputsAbstract;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.plumelib.options.Option;
import randoop.org.plumelib.options.OptionGroup;
import randoop.org.plumelib.options.Unpublicized;
import randoop.org.plumelib.util.StringsPlume;
import randoop.org.plumelib.util.SystemPlume;
import randoop.org.plumelib.util.UtilPlume;
import randoop.sequence.ExecutableSequence;
import randoop.sequence.Sequence;
import randoop.test.TestCheckGenerator;
import randoop.util.Log;
import randoop.util.ProgressDisplay;
import randoop.util.ReflectionExecutor;
import randoop.util.predicate.AlwaysFalse;

public abstract class AbstractGenerator {
    @OptionGroup(value="AbstractGenerator unpublicized options", unpublicized=true)
    @Unpublicized
    @Option(value="Dump each sequence to the log file")
    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean dump_sequences = false;
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int num_steps = 0;
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int null_steps = 0;
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int num_sequences_generated = 0;
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int num_failing_sequences = 0;
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int invalidSequenceCount = 0;
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int num_failed_output_test = 0;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown long startTime = -1L;
    protected @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> subsumed_sequences = new LinkedHashSet<Sequence>();
    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GenInputsAbstract.Limits limits;
    protected final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation> operations;
    protected @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutionVisitor executionVisitor;
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ComponentManager componentManager;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IStopper stopper;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ProgressDisplay progressDisplay;
    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence currSeq = null;
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSequence> outErrorSeqs;
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSequence> outRegressionSeqs;
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Predicate<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSequence> outputTest;
    protected @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TestCheckGenerator checkGenerator;
    protected @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationHistoryLogInterface operationHistory;

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown long elapsedTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    protected AbstractGenerator(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation> operations, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GenInputsAbstract.Limits limits, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ComponentManager componentManager, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IStopper stopper) {
        assert (operations != null);
        this.limits = limits;
        this.operations = operations;
        this.executionVisitor = new DummyVisitor();
        this.outputTest = new AlwaysFalse<ExecutableSequence>();
        this.componentManager = componentManager == null ? new ComponentManager() : componentManager;
        this.stopper = stopper;
        this.operationHistory = new DefaultOperationHistoryLogger();
        this.outRegressionSeqs = new ArrayList<ExecutableSequence>();
        this.outErrorSeqs = new ArrayList<ExecutableSequence>();
    }

    public void setTestPredicate(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Predicate<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSequence> outputTest) {
        if (outputTest == null) {
            throw new IllegalArgumentException("outputTest must be non-null");
        }
        this.outputTest = outputTest;
    }

    public void setExecutionVisitor(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutionVisitor executionVisitor) {
        if (executionVisitor == null) {
            throw new IllegalArgumentException("executionVisitor must be non-null");
        }
        this.executionVisitor = executionVisitor;
    }

    public void setExecutionVisitor(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutionVisitor> visitors) {
        this.executionVisitor = MultiVisitor.createMultiVisitor(visitors);
    }

    public void setTestCheckGenerator(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TestCheckGenerator checkGenerator) {
        if (checkGenerator == null) {
            throw new IllegalArgumentException("checkGenerator must be non-null");
        }
        this.checkGenerator = checkGenerator;
    }

    protected @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean shouldStop() {
        return this.limits.time_limit_millis != 0 && this.elapsedTime() >= (long)this.limits.time_limit_millis || this.numAttemptedSequences() >= this.limits.attempted_limit || this.numGeneratedSequences() >= this.limits.generated_limit || this.numOutputSequences() >= this.limits.output_limit || GenInputsAbstract.stop_on_error_test && this.numErrorSequences() > 0 || this.stopper != null && this.stopper.shouldStop();
    }

    public abstract @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSequence step();

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int numAttemptedSequences() {
        return this.num_steps;
    }

    public abstract @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int numGeneratedSequences();

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int numOutputSequences() {
        return this.outErrorSeqs.size() + this.outRegressionSeqs.size();
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int numErrorSequences() {
        return this.outErrorSeqs.size();
    }

    public void createAndClassifySequences() {
        if (this.checkGenerator == null) {
            throw new Error("Generator not properly initialized - must have a TestCheckGenerator");
        }
        this.startTime = System.currentTimeMillis();
        if (GenInputsAbstract.progressdisplay) {
            this.progressDisplay = new ProgressDisplay(this, ProgressDisplay.Mode.MULTILINE);
            this.progressDisplay.start();
        }
        while (!this.shouldStop()) {
            boolean test;
            ++this.num_steps;
            ExecutableSequence eSeq = this.step();
            if (dump_sequences) {
                Log.logPrintf("%nseq before run:%n%s%n", eSeq);
            }
            if (GenInputsAbstract.progressdisplay && GenInputsAbstract.progressintervalsteps != -1L && (long)this.num_steps % GenInputsAbstract.progressintervalsteps == 0L) {
                this.progressDisplay.display(!GenInputsAbstract.deterministic);
            }
            if (eSeq == null) {
                ++this.null_steps;
                continue;
            }
            ++this.num_sequences_generated;
            try {
                test = this.outputTest.test(eSeq);
            }
            catch (Throwable t2) {
                System.out.printf("%nProblem with sequence:%n%s%n%s%n", eSeq, UtilPlume.stackTraceToString(t2));
                throw t2;
            }
            if (test) {
                if (eSeq.hasInvalidBehavior()) {
                    ++this.invalidSequenceCount;
                } else if (eSeq.hasFailure()) {
                    this.operationHistory.add(eSeq.getOperation(), OperationOutcome.ERROR_SEQUENCE);
                    ++this.num_failing_sequences;
                    this.outErrorSeqs.add(eSeq);
                } else {
                    this.outRegressionSeqs.add(eSeq);
                    this.newRegressionTestHook(eSeq.sequence);
                }
            } else {
                ++this.num_failed_output_test;
            }
            if (!dump_sequences) continue;
            Log.logPrintf("Sequence after execution:%n%s%n", eSeq);
            Log.logPrintf("allSequences.size()=%s%n", this.numGeneratedSequences());
        }
        if (GenInputsAbstract.progressdisplay && this.progressDisplay != null) {
            this.progressDisplay.display(!GenInputsAbstract.deterministic);
            this.progressDisplay.shouldStop = true;
        }
        if (GenInputsAbstract.progressdisplay) {
            System.out.println();
            System.out.println("Normal method executions: " + ReflectionExecutor.normalExecs());
            System.out.println("Exceptional method executions: " + ReflectionExecutor.excepExecs());
            if (!GenInputsAbstract.deterministic) {
                System.out.println();
                System.out.println("Average method execution time (normal termination):      " + String.format("%.3g", ReflectionExecutor.normalExecAvgMillis()));
                System.out.println("Average method execution time (exceptional termination): " + String.format("%.3g", ReflectionExecutor.excepExecAvgMillis()));
                System.out.println("Approximate memory usage " + StringsPlume.abbreviateNumber(SystemPlume.usedMemory(false)));
            }
            System.out.println("Explorer = " + this);
        }
    }

    public abstract @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> getAllSequences();

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSequence> getRegressionSequences() {
        ArrayList<ExecutableSequence> unique_seqs = new ArrayList<ExecutableSequence>(this.outRegressionSeqs.size());
        this.subsumed_sequences = new LinkedHashSet<Sequence>();
        for (ExecutableSequence es : this.outRegressionSeqs) {
            this.subsumed_sequences.addAll(es.componentSequences);
        }
        for (ExecutableSequence es : this.outRegressionSeqs) {
            if (this.subsumed_sequences.contains(es.sequence)) {
                this.operationHistory.add(es.getOperation(), OperationOutcome.SUBSUMED);
                continue;
            }
            this.operationHistory.add(es.getOperation(), OperationOutcome.REGRESSION_SEQUENCE);
            unique_seqs.add(es);
        }
        return unique_seqs;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSequence> getErrorTestSequences() {
        return this.outErrorSeqs;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int outputSequenceCount() {
        return this.outRegressionSeqs.size() + this.outErrorSeqs.size();
    }

    void setCurrentSequence(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence s2) {
        currSeq = s2;
    }

    public void setOperationHistoryLogger(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationHistoryLogInterface logger) {
        this.operationHistory = logger;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OperationHistoryLogInterface getOperationHistory() {
        return this.operationHistory;
    }

    public abstract void newRegressionTestHook(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence var1);
}

