/*
 * Decompiled with CFR 0.152.
 */
package randoop.execution;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import randoop.Globals;
import randoop.org.apache.commons.exec.CommandLine;
import randoop.org.apache.commons.exec.DefaultExecuteResultHandler;
import randoop.org.apache.commons.exec.DefaultExecutor;
import randoop.org.apache.commons.exec.ExecuteWatchdog;
import randoop.org.apache.commons.exec.PumpStreamHandler;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.StringsPlume;
import randoop.util.Log;

public class RunCommand {
    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Status run(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> command, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path workingDirectory, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown long timeoutMillis) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown CommandException {
        List<String> errorOutputLines;
        List<String> standardOutputLines;
        String[] args = command.toArray(new String[0]);
        CommandLine cmdLine = new CommandLine(args[0]);
        cmdLine.addArguments(Arrays.copyOfRange(args, 1, args.length));
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        DefaultExecutor executor = ((DefaultExecutor.Builder)DefaultExecutor.builder().setWorkingDirectory(workingDirectory.toFile())).get();
        ExecuteWatchdog watchdog = ExecuteWatchdog.builder().setTimeout(Duration.ofMillis(timeoutMillis)).get();
        executor.setWatchdog(watchdog);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ByteArrayOutputStream errStream = new ByteArrayOutputStream();
        PumpStreamHandler streamHandler = new PumpStreamHandler(outStream, errStream);
        executor.setStreamHandler(streamHandler);
        Log.logPrintf("RunCommand.run():%n", new Object[0]);
        Log.logPrintf("  cd %s; %s%n", workingDirectory, StringsPlume.join((CharSequence)" ", command));
        Log.logPrintf("  timeoutMillis=%s, environment: %s%n", timeoutMillis, System.getenv());
        try {
            executor.execute(cmdLine, resultHandler);
        }
        catch (IOException e) {
            throw new CommandException("Exception starting process", e);
        }
        int exitValue = -1;
        try {
            resultHandler.waitFor();
            exitValue = resultHandler.getExitValue();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        boolean timedOut = executor.isFailure(exitValue) && watchdog.killedProcess();
        try {
            String outStreamString = outStream.toString();
            standardOutputLines = Arrays.asList(outStreamString.split(Globals.lineSep));
        }
        catch (RuntimeException e) {
            throw new CommandException("Exception getting process standard output", e);
        }
        try {
            String errStreamString = errStream.toString();
            errorOutputLines = Arrays.asList(errStreamString.split(Globals.lineSep));
        }
        catch (RuntimeException e) {
            throw new CommandException("Exception getting process error output", e);
        }
        return new Status(command, exitValue, timedOut, standardOutputLines, errorOutputLines);
    }

    public static class CommandException
    extends Throwable {
        private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown long serialVersionUID = 736230736083495268L;

        CommandException(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String message, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Throwable cause) {
            super(message, cause);
        }
    }

    public static class Status {
        public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> command;
        public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int exitStatus;
        public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean timedOut;
        public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> standardOutputLines;
        public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> errorOutputLines;

        Status(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> command, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int exitStatus, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean timedOut, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> standardOutputLines, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> errorOutputLines) {
            this.command = command;
            this.exitStatus = exitStatus;
            this.timedOut = timedOut;
            this.standardOutputLines = standardOutputLines;
            this.errorOutputLines = errorOutputLines;
        }

        @SideEffectFree
        public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Status %d (timedOut=%s) for command \"%s\"", this.exitStatus, this.timedOut, StringsPlume.join((CharSequence)" ", this.command)));
            this.describeLines("stdout", this.standardOutputLines, sb);
            this.describeLines("stderr", this.errorOutputLines, sb);
            return sb.toString();
        }

        private void describeLines(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String source, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> lines, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown StringBuilder sb) {
            if (lines.size() <= 2) {
                sb.append(", ");
                sb.append(source);
                sb.append("=\"");
                sb.append(StringsPlume.joinLines(lines));
                sb.append("\"");
                sb.append(Globals.lineSep);
            } else {
                sb.append(", ");
                sb.append(source);
                sb.append(" lines=");
                sb.append(lines.size());
            }
        }
    }
}

