/*
 * Decompiled with CFR 0.152.
 */
package randoop.contract;

import java.util.Arrays;
import java.util.Objects;
import randoop.contract.ObjectContract;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.StringsPlume;
import randoop.sequence.StringTooLongException;
import randoop.sequence.Value;
import randoop.types.JavaTypes;
import randoop.types.Type;
import randoop.types.TypeTuple;

public final class PrimValue
extends ObjectContract {
    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object value;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown EqualityMode equalityMode;
    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple inputTypes = new TypeTuple(Arrays.asList(JavaTypes.OBJECT_TYPE));

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrimValue)) {
            return false;
        }
        PrimValue other = (PrimValue)o;
        return this.value.equals(other.value);
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.value);
    }

    public PrimValue(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object value, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown EqualityMode equalityMode) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        Type type = Type.forClass(value.getClass());
        if (!type.isBoxedPrimitive() && !type.isString()) {
            throw new IllegalArgumentException("value is not a primitive or string : " + value.getClass());
        }
        if (value instanceof String && !Value.escapedStringLengthOk((String)value)) {
            throw new StringTooLongException((String)value);
        }
        this.value = value;
        this.equalityMode = equalityMode;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean evaluate(Object ... objects) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Throwable {
        assert (objects.length == 1);
        return this.value.equals(objects[0]);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int getArity() {
        return 1;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple getInputTypes() {
        return inputTypes;
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return "randoop.PrimValue, value=" + StringsPlume.escapeJava(this.value.toString());
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String get_observer_str() {
        return "PrimValue";
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toCodeString() {
        if (this.value.equals(Double.NaN)) {
            return "org.junit.Assert.assertTrue(Double.isNaN(x0));";
        }
        if (this.value.equals(Float.valueOf(Float.NaN))) {
            return "org.junit.Assert.assertTrue(Float.isNaN(x0));";
        }
        if (this.equalityMode.equals((Object)EqualityMode.EQUALSMETHOD)) {
            StringBuilder b = new StringBuilder();
            b.append("org.junit.Assert.assertEquals(");
            b.append("\"'\" + x0 + \"' != '\" + ").append(Value.toCodeString(this.value)).append("+ \"'\", ");
            b.append("x0");
            b.append(", ");
            b.append(Value.toCodeString(this.value));
            b.append(");");
            return b.toString();
        }
        if (this.equalityMode.equals((Object)EqualityMode.EQUALSEQUALS)) {
            StringBuilder b = new StringBuilder();
            b.append("org.junit.Assert.assertTrue(");
            b.append("\"'\" + x0 + \"' != '\" + ").append(Value.toCodeString(this.value)).append("+ \"'\", ");
            b.append("x0 == ").append(Value.toCodeString(this.value));
            b.append(");");
            return b.toString();
        }
        throw new Error("unexpected equalityMode " + (Object)((Object)this.equalityMode));
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toCommentString() {
        return null;
    }

    public static enum EqualityMode {
        EQUALSEQUALS,
        EQUALSMETHOD;

    }
}

