/*
 * Decompiled with CFR 0.152.
 */
package randoop.contract;

import java.util.Arrays;
import randoop.contract.ObjectContract;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.types.JavaTypes;
import randoop.types.TypeTuple;

public class CompareToAntiSymmetric
extends ObjectContract {
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown CompareToAntiSymmetric instance = new CompareToAntiSymmetric();
    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple inputTypes = new TypeTuple(Arrays.asList(JavaTypes.COMPARABLE_TYPE, JavaTypes.COMPARABLE_TYPE));

    private CompareToAntiSymmetric() {
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown CompareToAntiSymmetric getInstance() {
        return instance;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean evaluate(Object ... objects) {
        Object o1 = objects[0];
        Object o2 = objects[1];
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            Comparable compObj1 = (Comparable)o1;
            Comparable compObj2 = (Comparable)o2;
            return Math.signum(compObj1.compareTo(compObj2)) == -Math.signum(compObj2.compareTo(compObj1));
        }
        return true;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int getArity() {
        return 2;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple getInputTypes() {
        return inputTypes;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toCommentString() {
        return "compareTo-anti-symmetric on x0 and x1";
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String get_observer_str() {
        return "CompareToAntiSymmetric";
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toCodeString() {
        StringBuilder b = new StringBuilder();
        b.append("org.junit.Assert.assertTrue(");
        b.append("\"Contract failed: ").append(this.toCommentString()).append("\", ");
        b.append("Math.signum(x0.compareTo(x1)) == -Math.signum(x1.compareTo(x0))");
        b.append(");");
        return b.toString();
    }
}

