/*
 * Decompiled with CFR 0.152.
 */
package randoop.contract;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;
import randoop.Globals;
import randoop.contract.ObjectContract;
import randoop.main.RandoopBug;
import randoop.operation.TypedClassOperation;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.types.JavaTypes;
import randoop.types.TypeTuple;

public final class CheckRepContract
extends ObjectContract {
    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method checkRepMethod;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation operation;
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean returnsBoolean;
    public final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> declaringClass;

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckRepContract)) {
            return false;
        }
        CheckRepContract other = (CheckRepContract)o;
        return this.checkRepMethod.equals(other.checkRepMethod);
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.checkRepMethod);
    }

    public CheckRepContract(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method checkRepMethod) {
        if (checkRepMethod == null) {
            throw new IllegalArgumentException("check-rep method cannot be null.");
        }
        int modifiers = checkRepMethod.getModifiers();
        assert (Modifier.isPublic(modifiers));
        assert (!Modifier.isStatic(modifiers));
        assert (checkRepMethod.getParameterTypes().length == 0);
        this.operation = TypedOperation.forMethod(checkRepMethod);
        if (this.operation.getOutputType().equals(JavaTypes.BOOLEAN_TYPE)) {
            this.returnsBoolean = true;
        } else if (this.operation.getOutputType().equals(JavaTypes.VOID_TYPE)) {
            this.returnsBoolean = false;
        } else {
            throw new IllegalArgumentException("check-rep method must have void or boolean return type");
        }
        this.checkRepMethod = checkRepMethod;
        this.declaringClass = checkRepMethod.getDeclaringClass();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean evaluate(Object ... objects) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Throwable {
        assert (objects.length == 1);
        assert (objects[0] != null);
        if (this.declaringClass.equals(objects[0].getClass())) {
            try {
                if (this.returnsBoolean) {
                    return (Boolean)this.checkRepMethod.invoke(objects[0], new Object[0]);
                }
                this.checkRepMethod.invoke(objects[0], new Object[0]);
                return true;
            }
            catch (IllegalArgumentException e) {
                throw new RandoopBug(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        return true;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int getArity() {
        return 1;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeTuple getInputTypes() {
        return this.operation.getInputTypes();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toCommentString() {
        return "Check rep invariant (method " + this.checkRepMethod.getName() + ") for x0";
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String get_observer_str() {
        return "CheckRep " + this.checkRepMethod.getName();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toCodeString() {
        StringBuilder b = new StringBuilder();
        b.append(Globals.lineSep);
        b.append("// Check representation invariant.").append(Globals.lineSep);
        if (this.returnsBoolean) {
            b.append("org.junit.Assert.assertTrue(");
            b.append("\"Representation invariant failed: ").append(this.toCommentString()).append("\", ");
            b.append("x0.").append(this.checkRepMethod.getName()).append("()");
            b.append(");");
        } else {
            b.append("x0.").append(this.checkRepMethod.getName()).append("();");
        }
        return b.toString();
    }
}

