/*
 * Decompiled with CFR 0.152.
 */
package randoop.condition;

import java.util.ArrayList;
import java.util.List;
import randoop.condition.ExecutableBooleanExpression;
import randoop.condition.ThrowsClause;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.StringsPlume;
import randoop.test.ExpectedExceptionGenerator;
import randoop.test.ExtendGenerator;
import randoop.test.InvalidCheckGenerator;
import randoop.test.PostConditionCheckGenerator;
import randoop.test.TestCheckGenerator;

public class ExpectedOutcomeTable {
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isEmpty = true;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasSatisfiedPrecondition = false;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableBooleanExpression> postConditions = new ArrayList<ExecutableBooleanExpression>();
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ThrowsClause>> exceptionSets = new ArrayList<List<ThrowsClause>>();

    void add(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean guardIsSatisfied, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableBooleanExpression postcondition, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ThrowsClause> throwsClauses) {
        this.isEmpty = false;
        if (guardIsSatisfied) {
            this.hasSatisfiedPrecondition = true;
            if (postcondition != null) {
                this.postConditions.add(postcondition);
            }
        }
        if (!throwsClauses.isEmpty()) {
            this.exceptionSets.add(throwsClauses);
        }
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isInvalidCall() {
        return !this.isEmpty && !this.hasSatisfiedPrecondition && this.exceptionSets.isEmpty();
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TestCheckGenerator addPostCheckGenerator(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TestCheckGenerator gen) {
        if (this.isEmpty) {
            return gen;
        }
        if (!this.exceptionSets.isEmpty()) {
            return new ExpectedExceptionGenerator(this.exceptionSets);
        }
        if (!this.hasSatisfiedPrecondition) {
            gen = new InvalidCheckGenerator();
        }
        if (!this.postConditions.isEmpty()) {
            return new ExtendGenerator(new PostConditionCheckGenerator(this.postConditions), gen);
        }
        return gen;
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        if (this.isEmpty) {
            return "ExpectedOutcomeTable(empty)";
        }
        return String.format("ExpectedOutcomeTable(hasSatisfiedPrecondition=%s,%n  postConditions=%s, exceptionSets=%s)", this.hasSatisfiedPrecondition, StringsPlume.joinLines(this.postConditions), StringsPlume.joinLines(this.exceptionSets));
    }
}

