/*
 * Decompiled with CFR 0.152.
 */
package randoop.condition;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import randoop.condition.ExecutableBooleanExpression;
import randoop.condition.ExpectedOutcomeTable;
import randoop.condition.GuardPropertyPair;
import randoop.condition.GuardThrowsPair;
import randoop.condition.ThrowsClause;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public class ExecutableSpecification {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableBooleanExpression> preExpressions;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GuardPropertyPair> guardPropertyPairs;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GuardThrowsPair> guardThrowsPairs;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSpecification> parentList = new ArrayList<ExecutableSpecification>();

    public ExecutableSpecification() {
        this(new ArrayList<ExecutableBooleanExpression>(0), new ArrayList<GuardPropertyPair>(0), new ArrayList<GuardThrowsPair>(0));
    }

    public ExecutableSpecification(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableBooleanExpression> preExpressions, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GuardPropertyPair> guardPropertyPairs, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GuardThrowsPair> guardThrowsPairs) {
        this.preExpressions = preExpressions;
        this.guardPropertyPairs = guardPropertyPairs;
        this.guardThrowsPairs = guardThrowsPairs;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExpectedOutcomeTable checkPrestate(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] args) {
        ExpectedOutcomeTable table = new ExpectedOutcomeTable();
        this.checkPrestate(args, table);
        for (ExecutableSpecification execSpec : this.parentList) {
            execSpec.checkPrestate(args, table);
        }
        return table;
    }

    private void checkPrestate(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] args, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExpectedOutcomeTable table) {
        boolean preconditionCheck = this.checkPreExpressions(args);
        List<ThrowsClause> throwsClauses = this.checkGuardThrowsPairs(args);
        ExecutableBooleanExpression postCondition = this.checkGuardPropertyPairs(args);
        table.add(preconditionCheck, postCondition, throwsClauses);
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean checkPreExpressions(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] args) {
        for (ExecutableBooleanExpression preCondition : this.preExpressions) {
            if (preCondition.check(args)) continue;
            return false;
        }
        return true;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ThrowsClause> checkGuardThrowsPairs(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] args) {
        ArrayList<ThrowsClause> throwsClauses = new ArrayList<ThrowsClause>();
        for (GuardThrowsPair pair : this.guardThrowsPairs) {
            ExecutableBooleanExpression guard = pair.guard;
            if (!guard.check(args)) continue;
            throwsClauses.add(pair.throwsClause);
        }
        return throwsClauses;
    }

    private @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableBooleanExpression checkGuardPropertyPairs(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] args) {
        for (GuardPropertyPair gpPair : this.guardPropertyPairs) {
            ExecutableBooleanExpression guard = gpPair.guard;
            if (!guard.check(args)) continue;
            return gpPair.property.addPrestate(args);
        }
        return null;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSpecification merge(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSpecification spec1, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSpecification spec2) {
        LinkedHashSet<ExecutableBooleanExpression> mergedPreExpressionsSet = new LinkedHashSet<ExecutableBooleanExpression>(spec1.preExpressions);
        mergedPreExpressionsSet.addAll(spec2.preExpressions);
        ArrayList<ExecutableBooleanExpression> mergedPreExpressions = new ArrayList<ExecutableBooleanExpression>(mergedPreExpressionsSet);
        LinkedHashSet<GuardPropertyPair> mergedGuardPropertyPairsSet = new LinkedHashSet<GuardPropertyPair>(spec1.guardPropertyPairs);
        mergedGuardPropertyPairsSet.addAll(spec2.guardPropertyPairs);
        ArrayList<GuardPropertyPair> mergedGuardPropertyPairs = new ArrayList<GuardPropertyPair>(mergedGuardPropertyPairsSet);
        LinkedHashSet<GuardThrowsPair> mergedGuardThrowsPairsSet = new LinkedHashSet<GuardThrowsPair>(spec1.guardThrowsPairs);
        mergedGuardThrowsPairsSet.addAll(spec2.guardThrowsPairs);
        ArrayList<GuardThrowsPair> mergedGuardThrowsPairs = new ArrayList<GuardThrowsPair>(mergedGuardThrowsPairsSet);
        return new ExecutableSpecification(mergedPreExpressions, mergedGuardPropertyPairs, mergedGuardThrowsPairs);
    }

    void addParent(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSpecification parentExecSpec) {
        this.parentList.add(parentExecSpec);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isEmpty() {
        if (!(this.preExpressions.isEmpty() && this.guardPropertyPairs.isEmpty() && this.guardThrowsPairs.isEmpty())) {
            return false;
        }
        for (ExecutableSpecification execSpec : this.parentList) {
            if (execSpec.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return String.format("ExecutableSpecification:  preExpressions=%s  guardPropertyPairs=%s  guardThrowsPairs=%s", this.preExpressions, this.guardPropertyPairs, this.guardThrowsPairs);
    }
}

