/*
 * Decompiled with CFR 0.152.
 */
package randoop.condition;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import randoop.Globals;
import randoop.compile.SequenceCompiler;
import randoop.compile.SequenceCompilerException;
import randoop.condition.RandoopSpecificationError;
import randoop.main.GenInputsAbstract;
import randoop.main.RandoopBug;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.StringsPlume;
import randoop.output.NameGenerator;
import randoop.reflection.RawSignature;

public class ExecutableBooleanExpression {
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown NameGenerator classNameGenerator = new NameGenerator("RandoopExpressionClass");
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method expressionMethod;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String comment;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String contractSource;

    ExecutableBooleanExpression(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method expressionMethod, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String comment, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String contractSource) {
        this.expressionMethod = expressionMethod;
        this.comment = comment;
        this.contractSource = contractSource;
    }

    ExecutableBooleanExpression(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RawSignature signature, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String declarations, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String expressionSource, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String contractSource, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String comment, @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SequenceCompiler compiler) {
        this(ExecutableBooleanExpression.createMethod(signature, declarations, expressionSource, compiler), comment, contractSource);
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableBooleanExpression addPrestate(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] args) {
        return this;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ExecutableBooleanExpression)) {
            return false;
        }
        ExecutableBooleanExpression other = (ExecutableBooleanExpression)object;
        return this.expressionMethod.equals(other.expressionMethod) && this.comment.equals(other.comment) && this.contractSource.equals(other.contractSource);
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.expressionMethod, this.comment, this.contractSource);
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        if (this.comment == null || this.comment.isEmpty()) {
            return String.format("ExecutableBooleanExpression{contractSource=%s, expressionMethod=%s}", this.contractSource, this.expressionMethod);
        }
        return String.format("ExecutableBooleanExpression{contractSource=%s, comment=%s, expressionMethod=%s}", this.contractSource, this.comment, this.expressionMethod);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean check(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] values) {
        try {
            boolean result = (Boolean)this.expressionMethod.invoke(null, values);
            return result;
        }
        catch (IllegalAccessException e) {
            throw new RandoopSpecificationError("Failure executing expression method", e);
        }
        catch (InvocationTargetException e) {
            String messageDetails = String.format("  contractSource = %s%n  comment = %s%n  cause = %s", this.contractSource, this.comment, e.getCause());
            if (GenInputsAbstract.ignore_condition_exception) {
                if (!GenInputsAbstract.ignore_condition_exception_quiet) {
                    System.out.println("Failure executing expression method; fix the specification.");
                    System.out.println(messageDetails);
                    e.printStackTrace(System.out);
                }
                return false;
            }
            throw new RandoopSpecificationError("Failure executing expression method; fix the specification." + System.lineSeparator() + messageDetails);
        }
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getComment() {
        return this.comment;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getContractSource() {
        return this.contractSource;
    }

    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method createMethod(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RawSignature signature, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String parameterDeclaration, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String expressionSource, @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SequenceCompiler compiler) {
        Class<?> expressionClass;
        String packageName = signature.getPackageName();
        String classname = classNameGenerator.next();
        String classText = ExecutableBooleanExpression.createConditionClassSource(signature.getName(), expressionSource, parameterDeclaration, packageName, classname);
        try {
            expressionClass = compiler.compileAndLoad(packageName, classname, classText);
        }
        catch (SequenceCompilerException e) {
            String msg = ExecutableBooleanExpression.getCompilerErrorMessage(e.getDiagnostics().getDiagnostics(), classText);
            throw new RandoopSpecificationError(msg, e);
        }
        try {
            return expressionClass.getDeclaredMethod(signature.getName(), signature.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            throw new RandoopBug("Condition class does not contain expression method", e);
        }
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String createConditionClassSource(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String methodName, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String expressionText, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String parameterDeclarations, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String packageName, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String expressionClassName) {
        String packageDeclaration = "";
        if (packageName != null) {
            packageDeclaration = "package " + packageName + ";" + Globals.lineSep + Globals.lineSep;
        }
        return StringsPlume.joinLines(packageDeclaration + "public class " + expressionClassName + " {", "  public static boolean " + methodName + parameterDeclarations + " throws Throwable {", "    return " + expressionText + ";", "  }", "}" + Globals.lineSep);
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getCompilerErrorMessage(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Diagnostic<@RegexBottom @MustCall(value={}) @CalledMethodsBottom @BottomVal @SignednessBottom @SignatureBottom ? extends @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown JavaFileObject>> diagnostics, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String classText) {
        StringBuilder msg = new StringBuilder("Condition method did not compile:");
        msg.append(Globals.lineSep);
        for (Diagnostic<? extends JavaFileObject> diag : diagnostics) {
            if (diag == null) continue;
            String diagMessage = diag.getMessage(null);
            if (diagMessage.contains("unreported exception")) {
                diagMessage = String.format("expression threw exception %s", diagMessage.substring(0, diagMessage.indexOf(59)));
            }
            msg.append(String.format("%d:%d: %s%n", diag.getLineNumber(), diag.getColumnNumber(), diagMessage));
        }
        msg.append(String.format("%nClass being compiled:%n%s", classText));
        return msg.toString();
    }
}

