/*
 * Decompiled with CFR 0.152.
 */
package randoop.compile;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import randoop.Globals;
import randoop.compile.SequenceCompilerException;
import randoop.compile.SequenceJavaFileObject;
import randoop.main.RandoopBug;
import randoop.main.RandoopUsageError;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.calledmethods.qual.EnsuresCalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.mustcall.qual.Owning;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.BinaryName;
import randoop.org.checkerframework.checker.signature.qual.DotSeparatedIdentifiers;
import randoop.org.checkerframework.checker.signature.qual.Identifier;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.plumelib.reflection.ReflectionPlume;
import randoop.util.Log;

@MustCall(value={"close"})
public class SequenceCompiler
implements Closeable {
    public static final @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String debugCompilationFailure = null;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> compilerOptions;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown JavaCompiler compiler;
    @Owning
    private final @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown JavaFileManager fileManager;

    public SequenceCompiler() {
        this(new ArrayList<String>(0));
    }

    public SequenceCompiler(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> compilerOptions) {
        this.compilerOptions = new ArrayList<String>(compilerOptions.size() + 3);
        this.compilerOptions.addAll(compilerOptions);
        this.compilerOptions.add("-XDuseUnsharedTable");
        this.compilerOptions.add("-d");
        this.compilerOptions.add(".");
        this.compiler = ToolProvider.getSystemJavaCompiler();
        if (this.compiler == null) {
            throw new RandoopUsageError("Cannot find the Java compiler. Check that classpath includes tools.jar." + Globals.lineSep + "Classpath:" + Globals.lineSep + ReflectionPlume.classpathToString());
        }
        this.fileManager = this.compiler.getStandardFileManager(null, null, null);
    }

    @Override
    @EnsuresCalledMethods(value={"fileManager"}, methods={"close"})
    public void close() throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IOException {
        this.fileManager.close();
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isCompilable(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String packageName, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String classname, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String javaSource) {
        DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
        boolean result = this.compile(packageName, classname, javaSource, diagnostics);
        Path dir = Paths.get(packageName == null ? "." : packageName.replace(".", "/"), new String[0]);
        try {
            Files.delete(dir.resolve(classname + ".class"));
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            System.out.printf("Unable to delete %s: %s%n", dir.resolve(classname + ".class").toAbsolutePath(), e);
        }
        if (!result && debugCompilationFailure != null && javaSource.contains(debugCompilationFailure)) {
            StringJoiner sj = new StringJoiner(Globals.lineSep);
            sj.add("isCompilable => false");
            for (Diagnostic<JavaFileObject> d : diagnostics.getDiagnostics()) {
                sj.add(d.toString());
            }
            sj.add(javaSource);
            System.out.println(sj.toString());
        }
        return result;
    }

    private void compile(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String packageName, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String classname, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String javaSource) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SequenceCompilerException {
        DiagnosticCollector<JavaFileObject> diagnostics = new DiagnosticCollector<JavaFileObject>();
        boolean success = this.compile(packageName, classname, javaSource, diagnostics);
        if (!success) {
            throw new SequenceCompilerException("Compilation failed", javaSource, diagnostics);
        }
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean compile(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String packageName, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String classname, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String javaSource, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown DiagnosticCollector<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown JavaFileObject> diagnostics) {
        String classFileName = classname + ".java";
        ArrayList<SequenceJavaFileObject> sources = new ArrayList<SequenceJavaFileObject>(1);
        SequenceJavaFileObject source = new SequenceJavaFileObject(classFileName, javaSource);
        sources.add(source);
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, this.fileManager, diagnostics, new ArrayList<String>(this.compilerOptions), null, sources);
        Boolean succeeded = task.call();
        for (Diagnostic<JavaFileObject> diagnostic : diagnostics.getDiagnostics()) {
            String message;
            int lineNumber = (int)diagnostic.getLineNumber();
            if ((long)lineNumber == -1L) continue;
            Log.logPrintf("%nCompilation failed, see below for details:%n", new Object[0]);
            try {
                message = diagnostic.getMessage(null);
            }
            catch (Throwable t2) {
                message = diagnostic.toString();
            }
            if (source == null) {
                Log.logPrintf("Error on line %d: %s%n", lineNumber, message);
                continue;
            }
            String sourceUri = source.toUri().toString();
            Log.logPrintf("Error on line %d in %s: %s%n", lineNumber, sourceUri, message);
        }
        return succeeded != null && succeeded != false;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> compileAndLoad(@DotSeparatedIdentifiers @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String packageName, @Identifier @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String classname, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String javaSource) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SequenceCompilerException {
        this.compile(packageName, classname, javaSource);
        String fqName = this.fullyQualifiedName(packageName, classname);
        File dir = new File("").getAbsoluteFile();
        return SequenceCompiler.loadClassFile(dir, fqName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> loadClassFile(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown File directory, @BinaryName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String className) {
        try (URLClassLoader cl = new URLClassLoader(new URL[]{directory.toURI().toURL()});){
            Class<?> cls;
            Class<?> clazz = cls = cl.loadClass(className);
            return clazz;
        }
        catch (IOException | ClassNotFoundException | NoClassDefFoundError e) {
            throw new RandoopBug(e);
        }
    }

    @BinaryName @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String fullyQualifiedName(@DotSeparatedIdentifiers @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String packageName, @Identifier @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed String classname) {
        @BinaryName String result = (packageName == null ? "" : packageName + ".") + classname;
        return result;
    }
}

