/*
 * Decompiled with CFR 0.152.
 */
package randoop.com.github.javaparser.resolution.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import randoop.com.github.javaparser.resolution.types.ResolvedType;
import randoop.com.github.javaparser.utils.TypeUtils;

public enum ResolvedPrimitiveType implements ResolvedType
{
    BYTE("byte", Byte.class, Collections.emptyList()),
    SHORT("short", Short.class, Collections.singletonList(BYTE)),
    CHAR("char", Character.class, Collections.emptyList()),
    INT("int", Integer.class, Arrays.asList(BYTE, SHORT, CHAR)),
    LONG("long", Long.class, Arrays.asList(BYTE, SHORT, INT, CHAR)),
    BOOLEAN("boolean", Boolean.class, Collections.emptyList()),
    FLOAT("float", Float.class, Arrays.asList(LONG, INT, SHORT, BYTE, CHAR)),
    DOUBLE("double", Double.class, Arrays.asList(FLOAT, LONG, INT, SHORT, BYTE, CHAR));

    private String name;
    private Class boxTypeClass;
    private List<ResolvedPrimitiveType> promotionTypes;

    private ResolvedPrimitiveType(String name, Class boxTypeClass, List<ResolvedPrimitiveType> promotionTypes) {
        this.name = name;
        this.boxTypeClass = boxTypeClass;
        this.promotionTypes = promotionTypes;
    }

    public static ResolvedType byName(String name) {
        name = name.toLowerCase();
        for (ResolvedPrimitiveType ptu : ResolvedPrimitiveType.values()) {
            if (!ptu.describe().equals(name)) continue;
            return ptu;
        }
        throw new IllegalArgumentException("Name " + name);
    }

    public static boolean isBoxType(ResolvedType type) {
        if (!type.isReferenceType()) {
            return false;
        }
        String qName = type.asReferenceType().getQualifiedName();
        for (ResolvedPrimitiveType ptu : ResolvedPrimitiveType.values()) {
            if (!ptu.getBoxTypeQName().equals(qName)) continue;
            return true;
        }
        return false;
    }

    public static Optional<ResolvedType> byBoxTypeQName(String qName) {
        for (ResolvedPrimitiveType ptu : ResolvedPrimitiveType.values()) {
            if (!ptu.getBoxTypeQName().equals(qName)) continue;
            return Optional.of(ptu);
        }
        return Optional.empty();
    }

    public static ResolvedPrimitiveType[] getNumericPrimitiveTypes() {
        return new ResolvedPrimitiveType[]{BYTE, SHORT, INT, LONG, FLOAT, DOUBLE, CHAR};
    }

    public String toString() {
        return "PrimitiveTypeUsage{name='" + this.name + '\'' + '}';
    }

    @Override
    public ResolvedPrimitiveType asPrimitive() {
        return this;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public boolean isReferenceType() {
        return false;
    }

    @Override
    public String describe() {
        return this.name;
    }

    @Override
    public boolean isTypeVariable() {
        return false;
    }

    @Override
    public boolean isAssignableBy(ResolvedType other) {
        if (other.isPrimitive()) {
            return this == other || this.promotionTypes.contains(other);
        }
        if (other.isReferenceType()) {
            if (other.asReferenceType().getQualifiedName().equals(this.getBoxTypeQName())) {
                return true;
            }
            for (ResolvedPrimitiveType promotion : this.promotionTypes) {
                if (!other.asReferenceType().getQualifiedName().equals(promotion.getBoxTypeQName())) continue;
                return true;
            }
            return false;
        }
        return other.isConstraint() && this.isAssignableBy(other.asConstraintType().getBound());
    }

    public String getBoxTypeQName() {
        return this.boxTypeClass.getCanonicalName();
    }

    public Class getBoxTypeClass() {
        return this.boxTypeClass;
    }

    public boolean isNumeric() {
        return Arrays.asList(ResolvedPrimitiveType.getNumericPrimitiveTypes()).contains(this);
    }

    public boolean isBoolean() {
        return this == BOOLEAN;
    }

    public ResolvedPrimitiveType bnp(ResolvedPrimitiveType other) {
        if (this == DOUBLE || other == DOUBLE) {
            return DOUBLE;
        }
        if (this == FLOAT || other == FLOAT) {
            return FLOAT;
        }
        if (this == LONG || other == LONG) {
            return LONG;
        }
        return INT;
    }

    public static ResolvedType unp(ResolvedType type) {
        boolean isUnboxable;
        boolean bl = isUnboxable = type.isReferenceType() && type.asReferenceType().isUnboxable();
        if (isUnboxable && type.asReferenceType().toUnboxedType().get().in(BYTE, SHORT, CHAR, INT)) {
            return INT;
        }
        if (isUnboxable && type.asReferenceType().toUnboxedType().get().in(LONG, FLOAT, DOUBLE)) {
            return type.asReferenceType().toUnboxedType().get();
        }
        if (type.isPrimitive() && type.asPrimitive().in(BYTE, CHAR, SHORT)) {
            return INT;
        }
        return type;
    }

    public boolean in(ResolvedPrimitiveType ... types) {
        return Arrays.stream(types).anyMatch(type -> this == type);
    }

    @Override
    public String toDescriptor() {
        return TypeUtils.getPrimitiveTypeDescriptor(this.boxTypeClass);
    }
}

