/*
 * Decompiled with CFR 0.152.
 */
package randoop.com.github.javaparser.printer.configuration.imports;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import randoop.com.github.javaparser.ast.ImportDeclaration;
import randoop.com.github.javaparser.ast.NodeList;
import randoop.com.github.javaparser.ast.nodeTypes.NodeWithName;
import randoop.com.github.javaparser.printer.configuration.ImportOrderingStrategy;

public class IntelliJImportOrderingStrategy
implements ImportOrderingStrategy {
    private boolean sortImportsAlphabetically = false;

    @Override
    public List<NodeList<ImportDeclaration>> sortImports(NodeList<ImportDeclaration> nodes) {
        NodeList<ImportDeclaration> otherImports = new NodeList<ImportDeclaration>();
        NodeList<ImportDeclaration> javaImports = new NodeList<ImportDeclaration>();
        NodeList<ImportDeclaration> staticImports = new NodeList<ImportDeclaration>();
        for (ImportDeclaration importDeclaration : nodes) {
            if (importDeclaration.isStatic()) {
                staticImports.add(importDeclaration);
                continue;
            }
            String importName = importDeclaration.getNameAsString();
            if (importName.startsWith("java.") || importName.startsWith("javax.")) {
                javaImports.add(importDeclaration);
                continue;
            }
            otherImports.add(importDeclaration);
        }
        if (this.sortImportsAlphabetically) {
            Comparator<ImportDeclaration> sortLogic = Comparator.comparing(NodeWithName::getNameAsString);
            otherImports.sort(sortLogic);
            javaImports.sort(sortLogic);
            staticImports.sort(sortLogic);
        }
        return Arrays.asList(otherImports, javaImports, staticImports);
    }

    @Override
    public void setSortImportsAlphabetically(boolean sortAlphabetically) {
        this.sortImportsAlphabetically = sortAlphabetically;
    }

    @Override
    public boolean isSortImportsAlphabetically() {
        return this.sortImportsAlphabetically;
    }
}

