/*
 * Decompiled with CFR 0.152.
 */
package randoop.com.github.javaparser.ast.validator.language_level_validations;

import randoop.com.github.javaparser.ParserConfiguration;
import randoop.com.github.javaparser.ast.ImportDeclaration;
import randoop.com.github.javaparser.ast.Modifier;
import randoop.com.github.javaparser.ast.body.AnnotationDeclaration;
import randoop.com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import randoop.com.github.javaparser.ast.body.EnumDeclaration;
import randoop.com.github.javaparser.ast.body.Parameter;
import randoop.com.github.javaparser.ast.body.RecordDeclaration;
import randoop.com.github.javaparser.ast.expr.AnnotationExpr;
import randoop.com.github.javaparser.ast.expr.ClassExpr;
import randoop.com.github.javaparser.ast.expr.InstanceOfExpr;
import randoop.com.github.javaparser.ast.expr.LambdaExpr;
import randoop.com.github.javaparser.ast.expr.RecordPatternExpr;
import randoop.com.github.javaparser.ast.expr.SwitchExpr;
import randoop.com.github.javaparser.ast.expr.TextBlockLiteralExpr;
import randoop.com.github.javaparser.ast.modules.ModuleDeclaration;
import randoop.com.github.javaparser.ast.nodeTypes.NodeWithTokenRange;
import randoop.com.github.javaparser.ast.nodeTypes.NodeWithTypeArguments;
import randoop.com.github.javaparser.ast.nodeTypes.NodeWithTypeParameters;
import randoop.com.github.javaparser.ast.stmt.AssertStmt;
import randoop.com.github.javaparser.ast.stmt.ForEachStmt;
import randoop.com.github.javaparser.ast.stmt.SwitchEntry;
import randoop.com.github.javaparser.ast.stmt.TryStmt;
import randoop.com.github.javaparser.ast.stmt.YieldStmt;
import randoop.com.github.javaparser.ast.type.UnionType;
import randoop.com.github.javaparser.ast.validator.SimpleValidator;
import randoop.com.github.javaparser.ast.validator.SingleNodeTypeValidator;
import randoop.com.github.javaparser.ast.validator.TreeVisitorValidator;
import randoop.com.github.javaparser.ast.validator.Validator;
import randoop.com.github.javaparser.ast.validator.Validators;
import randoop.com.github.javaparser.ast.validator.language_level_validations.UpgradeJavaMessage;
import randoop.com.github.javaparser.ast.validator.language_level_validations.chunks.CommonValidators;
import randoop.com.github.javaparser.ast.validator.language_level_validations.chunks.ModifierValidator;
import randoop.com.github.javaparser.ast.validator.language_level_validations.chunks.NoBinaryIntegerLiteralsValidator;
import randoop.com.github.javaparser.ast.validator.language_level_validations.chunks.NoUnderscoresInIntegerLiteralsValidator;

public class Java1_0Validator
extends Validators {
    final Validator modifiersWithoutStrictfpAndDefaultAndStaticInterfaceMethodsAndPrivateInterfaceMethods = new ModifierValidator(false, false, false);
    final Validator noAssertKeyword = new SimpleValidator<AssertStmt>(AssertStmt.class, n -> true, (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("'assert' keyword is not supported.", ParserConfiguration.LanguageLevel.JAVA_1_4), new Object[0]));
    final Validator noInnerClasses = new SimpleValidator<ClassOrInterfaceDeclaration>(ClassOrInterfaceDeclaration.class, n -> !n.isTopLevelType(), (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("inner classes or interfaces are not supported.", ParserConfiguration.LanguageLevel.JAVA_1_1), new Object[0]));
    final Validator noReflection = new SimpleValidator<ClassExpr>(ClassExpr.class, n -> true, (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Reflection is not supported.", ParserConfiguration.LanguageLevel.JAVA_1_1), new Object[0]));
    final Validator noGenerics = new TreeVisitorValidator((node, reporter) -> {
        if (node instanceof NodeWithTypeArguments && ((NodeWithTypeArguments)((Object)node)).getTypeArguments().isPresent()) {
            reporter.report(node, new UpgradeJavaMessage("Generics are not supported.", ParserConfiguration.LanguageLevel.JAVA_5), new Object[0]);
        }
        if (node instanceof NodeWithTypeParameters && ((NodeWithTypeParameters)((Object)node)).getTypeParameters().isNonEmpty()) {
            reporter.report(node, new UpgradeJavaMessage("Generics are not supported.", ParserConfiguration.LanguageLevel.JAVA_5), new Object[0]);
        }
    });
    final SingleNodeTypeValidator<TryStmt> tryWithoutResources = new SingleNodeTypeValidator<TryStmt>(TryStmt.class, (n, reporter) -> {
        if (n.getCatchClauses().isEmpty() && !n.getFinallyBlock().isPresent()) {
            reporter.report(n, new UpgradeJavaMessage("Try has no finally and no catch.", ParserConfiguration.LanguageLevel.JAVA_7), new Object[0]);
        }
        if (n.getResources().isNonEmpty()) {
            reporter.report(n, new UpgradeJavaMessage("Catch with resource is not supported.", ParserConfiguration.LanguageLevel.JAVA_7), new Object[0]);
        }
    });
    final Validator noAnnotations = new TreeVisitorValidator((node, reporter) -> {
        if (node instanceof AnnotationExpr || node instanceof AnnotationDeclaration) {
            reporter.report(node, new UpgradeJavaMessage("Annotations are not supported.", ParserConfiguration.LanguageLevel.JAVA_5), new Object[0]);
        }
    });
    final Validator noEnums = new SimpleValidator<EnumDeclaration>(EnumDeclaration.class, n -> true, (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Enumerations are not supported.", ParserConfiguration.LanguageLevel.JAVA_5), new Object[0]));
    final Validator noVarargs = new SimpleValidator<Parameter>(Parameter.class, Parameter::isVarArgs, (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Varargs are not supported.", ParserConfiguration.LanguageLevel.JAVA_5), new Object[0]));
    final Validator noForEach = new SimpleValidator<ForEachStmt>(ForEachStmt.class, n -> true, (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("For-each loops are not supported.", ParserConfiguration.LanguageLevel.JAVA_5), new Object[0]));
    final Validator noStaticImports = new SimpleValidator<ImportDeclaration>(ImportDeclaration.class, ImportDeclaration::isStatic, (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Static imports are not supported.", ParserConfiguration.LanguageLevel.JAVA_5), new Object[0]));
    final Validator onlyOneLabelInSwitchCase = new SimpleValidator<SwitchEntry>(SwitchEntry.class, n -> n.getLabels().size() > 1, (n, reporter) -> reporter.report((NodeWithTokenRange)n.getLabels().getParentNode().get(), new UpgradeJavaMessage("Only one label allowed in a switch-case.", ParserConfiguration.LanguageLevel.JAVA_7), new Object[0]));
    final Validator noYield = new SimpleValidator<YieldStmt>(YieldStmt.class, n -> true, (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Only labels allowed in break statements.", ParserConfiguration.LanguageLevel.JAVA_13), new Object[0]));
    final Validator noBinaryIntegerLiterals = new NoBinaryIntegerLiteralsValidator();
    final Validator noUnderscoresInIntegerLiterals = new NoUnderscoresInIntegerLiteralsValidator();
    final Validator noMultiCatch = new SimpleValidator<UnionType>(UnionType.class, n -> true, (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Multi-catch is not supported.", ParserConfiguration.LanguageLevel.JAVA_7), new Object[0]));
    final Validator noLambdas = new SimpleValidator<LambdaExpr>(LambdaExpr.class, n -> true, (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Lambdas are not supported.", ParserConfiguration.LanguageLevel.JAVA_8), new Object[0]));
    final Validator noModules = new SimpleValidator<ModuleDeclaration>(ModuleDeclaration.class, n -> true, (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Modules are not supported.", ParserConfiguration.LanguageLevel.JAVA_9), new Object[0]));
    final Validator noSwitchExpressions = new SimpleValidator<SwitchExpr>(SwitchExpr.class, n -> true, (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Switch expressions are not supported.", ParserConfiguration.LanguageLevel.JAVA_12), new Object[0]));
    final Validator noPatternMatchingInstanceOf = new SimpleValidator<InstanceOfExpr>(InstanceOfExpr.class, n -> n.getPattern().isPresent(), (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Use of patterns with instanceof is not supported.", ParserConfiguration.LanguageLevel.JAVA_14), new Object[0]));
    final Validator noTextBlockLiteral = new SimpleValidator<TextBlockLiteralExpr>(TextBlockLiteralExpr.class, n -> true, (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Text Block Literals are not supported.", ParserConfiguration.LanguageLevel.JAVA_15), new Object[0]));
    final Validator noRecordDeclaration = new SimpleValidator<RecordDeclaration>(RecordDeclaration.class, n -> true, (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Record Declarations are not supported.", ParserConfiguration.LanguageLevel.JAVA_14), new Object[0]));
    final Validator noSealedClasses = new SimpleValidator<ClassOrInterfaceDeclaration>(ClassOrInterfaceDeclaration.class, n -> n.hasModifier(Modifier.Keyword.SEALED) || n.hasModifier(Modifier.Keyword.NON_SEALED), (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Sealed classes are not supported.", ParserConfiguration.LanguageLevel.JAVA_15), new Object[0]));
    final Validator noPermitsListInClasses = new SimpleValidator<ClassOrInterfaceDeclaration>(ClassOrInterfaceDeclaration.class, n -> n.getPermittedTypes().isNonEmpty(), (n, reporter) -> reporter.report((NodeWithTokenRange<?>)n, new UpgradeJavaMessage("Permitted sub-classes are not supported.", ParserConfiguration.LanguageLevel.JAVA_17), new Object[0]));
    final Validator noSwitchNullDefault = new SingleNodeTypeValidator<SwitchEntry>(SwitchEntry.class, (n, reporter) -> {
        if (n.getLabels().isNonEmpty() && n.isDefault()) {
            reporter.report(n, new UpgradeJavaMessage("Switch case null, default not supported.", ParserConfiguration.LanguageLevel.JAVA_21), new Object[0]);
        }
    });
    final Validator noSwitchPatterns = new SingleNodeTypeValidator<SwitchEntry>(SwitchEntry.class, (n, reporter) -> {
        if (n.getGuard().isPresent() || n.getLabels().stream().anyMatch(expr -> expr.isPatternExpr())) {
            reporter.report(n, new UpgradeJavaMessage("Switch patterns not supported.", ParserConfiguration.LanguageLevel.JAVA_21), new Object[0]);
        }
    });
    final Validator noRecordPatterns = new TreeVisitorValidator((node, reporter) -> {
        if (node instanceof RecordPatternExpr) {
            reporter.report(node, new UpgradeJavaMessage("Record patterns are not supported.", ParserConfiguration.LanguageLevel.JAVA_21), new Object[0]);
        }
    });

    public Java1_0Validator() {
        super(new CommonValidators());
        this.add(this.modifiersWithoutStrictfpAndDefaultAndStaticInterfaceMethodsAndPrivateInterfaceMethods);
        this.add(this.noAssertKeyword);
        this.add(this.noInnerClasses);
        this.add(this.noReflection);
        this.add(this.noGenerics);
        this.add(this.tryWithoutResources);
        this.add(this.noAnnotations);
        this.add(this.noEnums);
        this.add(this.noVarargs);
        this.add(this.noForEach);
        this.add(this.noStaticImports);
        this.add(this.noYield);
        this.add(this.onlyOneLabelInSwitchCase);
        this.add(this.noBinaryIntegerLiterals);
        this.add(this.noUnderscoresInIntegerLiterals);
        this.add(this.noMultiCatch);
        this.add(this.noLambdas);
        this.add(this.noModules);
        this.add(this.noSwitchExpressions);
        this.add(this.noPatternMatchingInstanceOf);
        this.add(this.noTextBlockLiteral);
        this.add(this.noRecordDeclaration);
        this.add(this.noSealedClasses);
        this.add(this.noPermitsListInClasses);
        this.add(this.noSwitchNullDefault);
        this.add(this.noSwitchPatterns);
        this.add(this.noRecordPatterns);
    }
}

