/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import randoop.Globals;
import randoop.main.RandoopBug;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;

public class TestCoverageInfo {
    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] branchTrue;
    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] branchFalse;
    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Integer>> methodToIndices;

    public TestCoverageInfo(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int totalBranches, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Integer>> map) {
        if (totalBranches < 0) {
            throw new IllegalArgumentException();
        }
        this.branchTrue = new int[totalBranches];
        this.branchFalse = new int[totalBranches];
        this.methodToIndices = Collections.unmodifiableMap(map);
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getCoverageInfo() {
        StringBuilder b = new StringBuilder();
        int totalBranchesCovered = 0;
        int totalBranches = 0;
        for (Map.Entry<String, Set<Integer>> entry : this.methodToIndices.entrySet()) {
            String methodSignature = entry.getKey();
            BranchCov covAndTot = this.getCoverageInfo(methodSignature);
            int branchesCovered = covAndTot.covered;
            int branchesInMethod = covAndTot.inMethod;
            totalBranchesCovered += branchesCovered;
            totalBranches += branchesInMethod;
            double percentCovered = (double)branchesCovered / (double)branchesInMethod;
            b.append((methodSignature == null ? "other" : methodSignature) + ": " + branchesCovered + "/" + branchesInMethod + " (" + percentCovered + "%)" + Globals.lineSep);
        }
        double totalPercent = (double)totalBranchesCovered / (double)totalBranches;
        b.append("TOTAL :" + totalBranchesCovered + "/" + totalBranches + " (" + totalPercent + "%)" + Globals.lineSep);
        return b.toString();
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown BranchCov getCoverageInfo(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String methodSignature) {
        Set<Integer> indices = this.methodToIndices.get(methodSignature);
        int totalBranches = indices.size() * 2;
        int branchesCovered = 0;
        for (Integer i : indices) {
            if (this.branchTrue[i] > 0) {
                ++branchesCovered;
            }
            if (this.branchFalse[i] <= 0) continue;
            ++branchesCovered;
        }
        assert (branchesCovered <= totalBranches);
        return new BranchCov(branchesCovered, totalBranches);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getCoverageInfo(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> clazz) {
        if (!TestCoverageInfo.isInstrumented(clazz)) {
            return "Class<?> not instrumented for branch coverage: " + clazz.getName();
        }
        try {
            return TestCoverageInfo.getCoverageInfoObject(clazz).getCoverageInfo();
        }
        catch (RandoopBug e) {
            throw e;
        }
        catch (Exception e) {
            throw new RandoopBug(e);
        }
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TestCoverageInfo getCoverageInfoObject(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> clazz) {
        try {
            Field f = clazz.getDeclaredField("randoopCoverageInfo");
            f.setAccessible(true);
            return (TestCoverageInfo)f.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new RandoopBug("Class " + clazz + " lacks the field randoopCoverageInfo", e);
        }
        catch (IllegalAccessException e) {
            throw new RandoopBug("this can't happen", e);
        }
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isInstrumented(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> clazz) {
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.getName().equals("randoopCoverageInfo")) continue;
            return true;
        }
        return false;
    }

    private static class BranchCov {
        final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int covered;
        final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int inMethod;

        BranchCov(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int covered, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int inMethod) {
            this.covered = covered;
            this.inMethod = inMethod;
        }
    }
}

