/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeoutException;
import randoop.ExceptionalExecution;
import randoop.ExecutionOutcome;
import randoop.NormalExecution;
import randoop.main.RandoopBug;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.plumelib.options.Option;
import randoop.org.plumelib.options.OptionGroup;
import randoop.org.plumelib.util.FileWriterWithName;
import randoop.util.Log;
import randoop.util.ReflectionCode;
import randoop.util.RunnerThread;

public final class ReflectionExecutor {
    @OptionGroup(value="Threading")
    @Option(value="Execute each test in a separate thread, with timeout")
    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean usethreads = false;
    @Option(value="<filename> logs timed-out tests to the specified file")
    public static @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown FileWriterWithName timed_out_tests = null;
    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int CALL_TIMEOUT_MILLIS_DEFAULT;
    @Option(value="Maximum number of milliseconds a test may run. Only meaningful with --usethreads")
    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int call_timeout_millis;
    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown long normal_exec_duration_nanos;
    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int normal_exec_count;
    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown long excep_exec_duration_nanos;
    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int excep_exec_count;

    private ReflectionExecutor() {
        throw new Error("Do not instantiate");
    }

    public static void resetStatistics() {
        normal_exec_duration_nanos = 0L;
        normal_exec_count = 0;
        excep_exec_duration_nanos = 0L;
        excep_exec_count = 0;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int normalExecs() {
        return normal_exec_count;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int excepExecs() {
        return excep_exec_count;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown double normalExecAvgMillis() {
        return (double)normal_exec_duration_nanos / (double)normal_exec_count / Math.pow(10.0, 6.0);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown double excepExecAvgMillis() {
        return (double)excep_exec_duration_nanos / (double)excep_exec_count / Math.pow(10.0, 6.0);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutionOutcome executeReflectionCode(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionCode code) {
        long startTimeNanos = System.nanoTime();
        if (usethreads) {
            try {
                ReflectionExecutor.executeReflectionCodeThreaded(code);
            }
            catch (TimeoutException e) {
                if (timed_out_tests != null) {
                    try {
                        String msg = String.format("Killed thread: %s%nReason: %s%n--------------------%n", code, e.getMessage());
                        timed_out_tests.write(msg);
                        timed_out_tests.flush();
                    }
                    catch (IOException ex) {
                        throw new RandoopBug("Error writing to demand-driven logging file: " + ex);
                    }
                }
                return new ExceptionalExecution(e, (long)call_timeout_millis * 1000000L);
            }
        }
        ReflectionExecutor.executeReflectionCodeUnThreaded(code);
        long durationNanos = System.nanoTime() - startTimeNanos;
        if (code.getExceptionThrown() != null) {
            assert ((excep_exec_duration_nanos += durationNanos) >= 0L);
            ++excep_exec_count;
            return new ExceptionalExecution(code.getExceptionThrown(), durationNanos);
        }
        assert ((normal_exec_duration_nanos += durationNanos) >= 0L);
        ++normal_exec_count;
        return new NormalExecution(code.getReturnValue(), durationNanos);
    }

    private static void executeReflectionCodeThreaded(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionCode code) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TimeoutException {
        RunnerThread runnerThread = new RunnerThread(null);
        runnerThread.setup(code);
        try {
            runnerThread.start();
            runnerThread.join(call_timeout_millis);
            if (!runnerThread.runFinished) {
                Log.logPrintf("Exceeded timeout: aborting execution of call: %s%n", runnerThread.getCode());
                runnerThread.stop();
                throw new TimeoutException();
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("A RunnerThread thread shouldn't be interrupted by anyone! (This may be a bug in Randoop; please report it at https://github.com/randoop/randoop/issues , providing the information requested at https://randoop.github.io/randoop/manual/index.html#bug-reporting .)");
        }
    }

    private static void executeReflectionCodeUnThreaded(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionCode code) {
        try {
            code.runReflectionCode();
            return;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (ReflectionCode.ReflectionCodeException e) {
            throw new RandoopBug("code=" + code, e);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                throw new RandoopBug("Unexpected InvocationTargetException", e);
            }
            throw e;
        }
    }

    static {
        call_timeout_millis = CALL_TIMEOUT_MILLIS_DEFAULT = 5000;
        normal_exec_duration_nanos = 0L;
        normal_exec_count = 0;
        excep_exec_duration_nanos = 0L;
        excep_exec_count = 0;
    }
}

