/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.plumelib.util.StringsPlume;

public abstract class ReflectionCode {
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasStarted;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasRun;
    protected @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object retval;
    protected @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Throwable exceptionThrown;

    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasStarted() {
        return this.hasStarted;
    }

    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasRun() {
        return this.hasRun;
    }

    protected final void setHasStarted() {
        if (this.hasStarted) {
            throw new ReflectionCodeException("cannot run this twice");
        }
        this.hasStarted = true;
    }

    protected final void setHasRun() {
        if (this.hasRun) {
            throw new ReflectionCodeException("cannot run this twice");
        }
        this.hasRun = true;
    }

    public final void runReflectionCode() throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionCodeException {
        this.setHasStarted();
        this.runReflectionCodeRaw();
        this.setHasRun();
    }

    protected abstract void runReflectionCodeRaw() throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionCodeException;

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object getReturnValue() {
        if (!this.hasRun()) {
            throw new IllegalStateException("run first, then ask");
        }
        return this.retval;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Throwable getExceptionThrown() {
        if (!this.hasRun()) {
            throw new IllegalStateException("run first, then ask");
        }
        return this.exceptionThrown;
    }

    protected @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String status() {
        if (!this.hasStarted() && !this.hasRun()) {
            return " not run yet";
        }
        if (this.hasStarted() && !this.hasRun()) {
            return " failed to run";
        }
        if (!this.hasStarted() && this.hasRun()) {
            return " ILLEGAL STATE";
        }
        if (this.exceptionThrown == null) {
            return " returned: " + StringsPlume.toStringAndClass(this.retval);
        }
        return " threw: " + this.exceptionThrown;
    }

    static final class ReflectionCodeException
    extends IllegalStateException {
        private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown long serialVersionUID = -7508201027241079866L;

        ReflectionCodeException(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String msg) {
            super(msg);
        }

        ReflectionCodeException(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String msg, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Throwable cause) {
            super(msg, cause);
        }

        ReflectionCodeException(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Throwable cause) {
            super(cause);
        }
    }
}

