/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.plumelib.util.FilesPlume;
import randoop.util.RecordProcessor;

public class RecordListReader {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String startMarker;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String endMarker;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RecordProcessor processor;

    public RecordListReader(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String recordType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RecordProcessor proc) {
        if (recordType == null || recordType.length() == 0) {
            throw new IllegalArgumentException("No record type given: " + (recordType == null ? "null" : "\"\""));
        }
        if (proc == null) {
            throw new IllegalArgumentException("proc cannot be null.");
        }
        this.processor = proc;
        this.startMarker = "START " + recordType;
        this.endMarker = "END " + recordType;
    }

    public void parse(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String inFile) {
        if (inFile == null || inFile.length() == 0) {
            throw new IllegalArgumentException("Illegal input file name: " + inFile);
        }
        try (BufferedReader reader = FilesPlume.newBufferedFileReader(inFile);){
            this.parse(reader);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public void parse(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Path inFile) {
        if (inFile == null) {
            throw new IllegalArgumentException("Null input file");
        }
        try (BufferedReader reader = FilesPlume.newBufferedFileReader(inFile.toFile());){
            this.parse(reader);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public void parse(@UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown BufferedReader reader) {
        try {
            String line = RecordListReader.nextNWCLine(reader);
            while (line != null) {
                if (!(line = line.trim()).startsWith(this.startMarker)) {
                    throw new IllegalArgumentException("Expected \"" + this.startMarker + "\" but got " + line);
                }
                List<String> oneRecord = this.readOneRecord(reader);
                this.processor.processRecord(oneRecord);
                line = RecordListReader.nextNWCLine(reader);
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> readOneRecord(@UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown BufferedReader reader) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IOException {
        ArrayList<String> ret = new ArrayList<String>();
        String line = RecordListReader.nextNWCLine(reader);
        while (line != null && !line.equals(this.endMarker)) {
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            ret.add(line);
            line = RecordListReader.nextNWCLine(reader);
        }
        return ret;
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String nextNWCLine(@UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown BufferedReader reader) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IOException {
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        while (line != null && (line.length() == 0 || line.indexOf(35) == 0)) {
            line = reader.readLine();
            if (line == null) continue;
            line = line.trim();
        }
        return line;
    }
}

