/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.util.SimpleList;

public final class OneMoreElementList<@RegexBottom E>
implements SimpleList<E>,
Serializable {
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown long serialVersionUID = 1332963552183905833L;
    public final E lastElement;
    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleList<E> list;
    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int size;

    public OneMoreElementList(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleList<E> list, E extraElement) {
        this.list = list;
        this.lastElement = extraElement;
        this.size = list.size() + 1;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int size() {
        return this.size;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public E get(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int index) {
        if (index < this.size - 1) {
            return this.list.get(index);
        }
        if (index == this.size - 1) {
            return this.lastElement;
        }
        throw new IndexOutOfBoundsException("No such element: " + index);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleList<E> getSublist(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int index) {
        if (index == this.size - 1) {
            return this;
        }
        if (index < this.size - 1) {
            return this.list.getSublist(index);
        }
        throw new IndexOutOfBoundsException("No such index: " + index);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<E> toJDKList() {
        ArrayList<E> result = new ArrayList<E>();
        result.addAll(this.list.toJDKList());
        result.add(this.lastElement);
        return result;
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return this.toJDKList().toString();
    }
}

