/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.util.IMultiMap;

public class MultiMap<@RegexBottom K, @RegexBottom V>
implements IMultiMap<K, V> {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<K, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<V>> map;

    public MultiMap() {
        this.map = new LinkedHashMap<K, Set<V>>();
    }

    public MultiMap(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int initialCapacity) {
        this.map = new LinkedHashMap<K, Set<V>>(initialCapacity);
    }

    public static <K, V> @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MultiMap<K, V> empty() {
        return EmptyMultiMap.instance;
    }

    public void put(K key, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Collection<@RegexBottom @MustCall(value={}) @CalledMethodsBottom @BottomVal @SignednessBottom @SignatureBottom ? extends V> values) {
        if (this.contains(key)) {
            this.remove(key);
        }
        this.map.put(key, new LinkedHashSet<V>(values));
    }

    public void addAll(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@RegexBottom @MustCall(value={}) @CalledMethodsBottom @BottomVal @SignednessBottom @SignatureBottom ? extends K, @RegexBottom @MustCall(value={}) @CalledMethodsBottom @BottomVal @SignednessBottom @SignatureBottom ? extends V> m4) {
        for (K t1 : m4.keySet()) {
            this.add(t1, m4.get(t1));
        }
    }

    public void addAll(K key, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Collection<@RegexBottom @MustCall(value={}) @CalledMethodsBottom @BottomVal @SignednessBottom @SignatureBottom ? extends V> values) {
        for (V t2 : values) {
            this.add(key, t2);
        }
    }

    public void addAll(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MultiMap<K, V> mmap) {
        for (Map.Entry<K, Set<V>> entry : mmap.map.entrySet()) {
            this.addAll(entry.getKey(), (Collection)entry.getValue());
        }
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean add(K key, V value) {
        Set values = this.map.computeIfAbsent(key, __ -> new LinkedHashSet(1));
        return values.add(value);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean remove(K key, V value) {
        Set<V> values = this.map.get(key);
        if (values == null) {
            throw new IllegalStateException("No values were found when trying to remove from multiset. Key: " + key + " Variable: " + value);
        }
        return values.remove(value);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean remove(K key) {
        Set<V> values = this.map.get(key);
        if (values == null) {
            throw new IllegalStateException("No values were found when trying to remove from multiset. Key: " + key);
        }
        return this.map.remove(key) != null;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<V> getValues(K key) {
        return this.map.getOrDefault(key, Collections.emptySet());
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<K> keySet() {
        return this.map.keySet();
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean contains(K obj) {
        return this.map.containsKey(obj);
    }

    public void clear() {
        this.map.clear();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int size() {
        return this.map.size();
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return this.map.toString();
    }

    private static class EmptyMultiMap<@RegexBottom K, @RegexBottom V>
    extends MultiMap<K, V> {
        public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown EmptyMultiMap instance = new EmptyMultiMap();

        private EmptyMultiMap() {
            super(0);
        }

        @Override
        public void put(K key, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Collection<@RegexBottom @MustCall(value={}) @CalledMethodsBottom @BottomVal @SignednessBottom @SignatureBottom ? extends V> values) {
            throw new UnsupportedOperationException("EmptyMultiMap.put");
        }

        @Override
        public void addAll(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@RegexBottom @MustCall(value={}) @CalledMethodsBottom @BottomVal @SignednessBottom @SignatureBottom ? extends K, @RegexBottom @MustCall(value={}) @CalledMethodsBottom @BottomVal @SignednessBottom @SignatureBottom ? extends V> m4) {
            throw new UnsupportedOperationException("EmptyMultiMap.addAll");
        }

        @Override
        public void addAll(K key, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Collection<@RegexBottom @MustCall(value={}) @CalledMethodsBottom @BottomVal @SignednessBottom @SignatureBottom ? extends V> values) {
            throw new UnsupportedOperationException("EmptyMultiMap.addAll");
        }

        @Override
        public void addAll(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MultiMap<K, V> mmap) {
            throw new UnsupportedOperationException("EmptyMultiMap.addAll");
        }

        @Override
        public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean add(K key, V value) {
            throw new UnsupportedOperationException("EmptyMultiMap.add");
        }

        @Override
        public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean remove(K key, V value) {
            throw new UnsupportedOperationException("EmptyMultiMap.remove");
        }

        @Override
        public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean remove(K key) {
            throw new UnsupportedOperationException("EmptyMultiMap.remove");
        }

        @Override
        public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<V> getValues(K key) {
            return Collections.emptySet();
        }

        @Override
        public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<K> keySet() {
            return Collections.emptySet();
        }

        @Override
        public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean contains(K obj) {
            return false;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("EmptyMultiMap.clear");
        }

        @Override
        public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int size() {
            return 0;
        }

        @Override
        public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isEmpty() {
            return true;
        }

        @Override
        @SideEffectFree
        public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
            return "{}";
        }
    }
}

