/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import randoop.main.RandoopBug;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.util.SimpleList;

public class ListOfLists<@RegexBottom E>
implements SimpleList<E>,
Serializable {
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown long serialVersionUID = -3307714585442970263L;
    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleList<E>> lists;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] cumulativeSize;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int totalelements;

    public ListOfLists(SimpleList<E> ... lists) {
        this.lists = Arrays.asList(lists);
        this.cumulativeSize = new int[lists.length];
        this.totalelements = 0;
        for (int i = 0; i < lists.length; ++i) {
            SimpleList<E> l = lists[i];
            if (l == null) {
                throw new IllegalArgumentException("All lists should be non-null");
            }
            this.totalelements += l.size();
            this.cumulativeSize[i] = this.totalelements;
        }
    }

    public ListOfLists(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleList<E>> lists) {
        if (lists == null) {
            throw new IllegalArgumentException("param cannot be null");
        }
        this.lists = lists;
        this.cumulativeSize = new int[lists.size()];
        this.totalelements = 0;
        for (int i = 0; i < lists.size(); ++i) {
            SimpleList<SimpleList<E>> l = lists.get(i);
            this.totalelements += l.size();
            this.cumulativeSize[i] = this.totalelements;
        }
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int size() {
        return this.totalelements;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isEmpty() {
        return this.totalelements == 0;
    }

    @Override
    public E get(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int index) {
        if (index < 0 || index > this.totalelements - 1) {
            throw new IllegalArgumentException("index must be between 0 and size()-1");
        }
        int previousListSize = 0;
        for (int i = 0; i < this.cumulativeSize.length; ++i) {
            if (index < this.cumulativeSize[i]) {
                return this.lists.get(i).get(index - previousListSize);
            }
            previousListSize = this.cumulativeSize[i];
        }
        throw new RandoopBug("Indexing error in ListOfLists");
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleList<E> getSublist(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int index) {
        if (index < 0 || index > this.totalelements - 1) {
            throw new IllegalArgumentException("index must be between 0 and size()-1");
        }
        int previousListSize = 0;
        for (int i = 0; i < this.cumulativeSize.length; ++i) {
            if (index < this.cumulativeSize[i]) {
                return this.lists.get(i).getSublist(index - previousListSize);
            }
            previousListSize = this.cumulativeSize[i];
        }
        throw new RandoopBug("indexing error in ListOfLists");
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<E> toJDKList() {
        ArrayList<E> result = new ArrayList<E>();
        for (SimpleList<E> l : this.lists) {
            result.addAll(l.toJDKList());
        }
        return result;
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return this.toJDKList().toString();
    }
}

