/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.util.CollectionsExt;

public class JarReader {
    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean debug = false;

    private JarReader() {
        throw new Error("Do not instantiate");
    }

    public static void main(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] args) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IOException {
        List<String> names = JarReader.getClasseNamesInJar(args[0]);
        Collections.sort(names);
        System.out.println(CollectionsExt.toStringInLines(names));
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> getClassNamesInPackage(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String jarName, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String packageName) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IOException {
        ArrayList<String> classes = new ArrayList<String>();
        packageName = packageName.replaceAll("\\.", "/");
        if (debug) {
            System.out.println("Jar " + jarName + " looking for " + packageName);
        }
        try (FileInputStream fis = new FileInputStream(jarName);
             JarInputStream jarFile = new JarInputStream(fis);){
            JarEntry jarEntry;
            while ((jarEntry = jarFile.getNextJarEntry()) != null) {
                if (!jarEntry.getName().startsWith(packageName) || !jarEntry.getName().endsWith(".class")) continue;
                if (debug) {
                    System.out.println(jarEntry.getName().replaceAll("/", "\\."));
                }
                classes.add(jarEntry.getName().replaceAll("/", "\\."));
            }
        }
        return classes;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> getClasseNamesInJar(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String jarName) throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IOException {
        ArrayList<String> classes = new ArrayList<String>();
        if (debug) {
            System.out.println("Jar " + jarName);
        }
        try (FileInputStream fis = new FileInputStream(jarName);
             JarInputStream jarFile = new JarInputStream(fis);){
            JarEntry jarEntry;
            while ((jarEntry = jarFile.getNextJarEntry()) != null) {
                if (!jarEntry.getName().endsWith(".class")) continue;
                if (debug) {
                    System.out.println(jarEntry.getName().replaceAll("/", "\\."));
                }
                classes.add(jarEntry.getName().replaceAll("/", "\\."));
            }
        }
        return classes;
    }
}

