/*
 * Decompiled with CFR 0.152.
 */
package randoop.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import randoop.Globals;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.plumelib.util.CollectionsPlume;
import randoop.org.plumelib.util.StringsPlume;

public final class CollectionsExt {
    private CollectionsExt() {
        throw new IllegalStateException("no instances");
    }

    static <T> T getNthIteratedElement(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Collection<@RegexBottom @MustCall(value={}) @CalledMethodsBottom @BottomVal @SignednessBottom @SignatureBottom ? extends T> s2, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int index) {
        if (s2 == null) {
            throw new IllegalArgumentException("s cannot be null.");
        }
        if (s2.isEmpty()) {
            throw new IllegalArgumentException("s cannot be empty.");
        }
        if (index >= s2.size()) {
            throw new IllegalArgumentException("Index " + index + " out of bounds for set of size " + s2.size());
        }
        return CollectionsExt.getNthIteratedElement(s2.iterator(), index);
    }

    private static <T> T getNthIteratedElement(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Iterator<@RegexBottom @MustCall(value={}) @CalledMethodsBottom @BottomVal @SignednessBottom @SignatureBottom ? extends T> iter, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index " + index + " out of bounds");
        }
        int counter = 0;
        while (iter.hasNext()) {
            if (counter == index) {
                return iter.next();
            }
            iter.next();
            ++counter;
        }
        throw new IllegalArgumentException("index " + index + " out of bounds, size=" + counter);
    }

    static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toStringInLines(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Collection<@RegexBottom @MustCall(value={}) @CalledMethodsBottom @BottomVal @SignednessBottom @SignatureBottom ? extends @Signed @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @SignatureUnknown Object> c) {
        if (c.isEmpty()) {
            return "";
        }
        return StringsPlume.joinLines(CollectionsExt.toStringLines(c)) + Globals.lineSep;
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> toStringLines(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Collection<@RegexBottom @MustCall(value={}) @CalledMethodsBottom @BottomVal @SignednessBottom @SignatureBottom ? extends @Signed @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @SignatureUnknown Object> c) {
        return CollectionsPlume.mapList(String::valueOf, c);
    }
}

