/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.util.HashSet;
import java.util.Objects;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.types.EagerReferenceBound;
import randoop.types.JavaTypes;
import randoop.types.ParameterBound;
import randoop.types.ParameterType;
import randoop.types.Substitution;

class WildcardType
extends ParameterType {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasUpperBound;

    private WildcardType() {
        this.hasUpperBound = false;
    }

    WildcardType(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound bound, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasUpperBound) {
        this.hasUpperBound = hasUpperBound;
        if (hasUpperBound) {
            this.setUpperBound(bound);
        } else {
            this.setLowerBound(bound);
        }
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown WildcardType forType(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown java.lang.reflect.WildcardType type) {
        if (type.getLowerBounds().length > 0) {
            assert (type.getLowerBounds().length == 1) : "a wildcard is defined by the JLS to only have one bound";
            return new WildcardType(ParameterBound.forTypes(new HashSet(0), type.getLowerBounds()), false);
        }
        if (type.getUpperBounds().length > 0) {
            assert (type.getUpperBounds().length == 1) : "a wildcard is defined by the JLS to only have one bound";
            return new WildcardType(ParameterBound.forTypes(new HashSet(0), type.getUpperBounds()), true);
        }
        throw new IllegalArgumentException("A wildcard must have either upper or lower bounds");
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WildcardType)) {
            return false;
        }
        WildcardType otherType = (WildcardType)obj;
        return otherType.hasUpperBound == this.hasUpperBound && super.equals(otherType);
    }

    @Override
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.hasUpperBound, super.hashCode());
    }

    @Override
    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        if (this.hasUpperBound) {
            if (this.getUpperTypeBound().isObject()) {
                return "?";
            }
            return "? extends " + this.getUpperTypeBound().toString();
        }
        return "? super " + this.getLowerTypeBound().toString();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getFqName() {
        if (this.hasUpperBound) {
            if (this.getUpperTypeBound().isObject()) {
                return "?";
            }
            return "? extends " + this.getUpperTypeBound().toString();
        }
        return "? super " + this.getLowerTypeBound().toString();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getBinaryName() {
        if (this.hasUpperBound) {
            if (this.getUpperTypeBound().isObject()) {
                return "?";
            }
            return "? extends " + this.getUpperTypeBound().toString();
        }
        return "? super " + this.getLowerTypeBound().toString();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getSimpleName() {
        return this.toString();
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound getTypeBound() {
        if (this.hasUpperBound) {
            return this.getUpperTypeBound();
        }
        return this.getLowerTypeBound();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown WildcardType substitute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        ParameterBound bound = this.getTypeBound().substitute(substitution);
        if (bound.equals(this.getTypeBound())) {
            return this;
        }
        return new WildcardType(bound, this.hasUpperBound);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown WildcardType applyCaptureConversion() {
        if (this.getTypeBound().hasWildcard()) {
            EagerReferenceBound convertedType = (EagerReferenceBound)this.getTypeBound().applyCaptureConversion();
            return new WildcardType((ParameterBound)convertedType, this.hasUpperBound);
        }
        return this;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean contains(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown WildcardType otherType) {
        if (this.hasUpperBound) {
            return otherType.hasUpperBound && this.getUpperTypeBound().isSubtypeOf(otherType.getUpperTypeBound());
        }
        if (otherType.hasUpperBound) {
            return otherType.getUpperTypeBound().equals(new EagerReferenceBound(JavaTypes.OBJECT_TYPE));
        }
        return otherType.getLowerTypeBound().isSubtypeOf(this.getLowerTypeBound());
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isGeneric(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean ignoreWildcards) {
        return this.getTypeBound().isGeneric(ignoreWildcards);
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasUpperBound() {
        return this.hasUpperBound;
    }
}

