/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.types.CaptureTypeVariable;
import randoop.types.ParameterBound;
import randoop.types.ReferenceArgument;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.TypeArgument;
import randoop.types.TypeVariable;
import randoop.types.WildcardType;

public class WildcardArgument
extends TypeArgument {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown WildcardType argumentType;

    WildcardArgument(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown WildcardType argumentType) {
        this.argumentType = argumentType;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown WildcardArgument forType(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type type) {
        if (!(type instanceof java.lang.reflect.WildcardType)) {
            throw new IllegalArgumentException("Must be a wildcard type " + type);
        }
        java.lang.reflect.WildcardType wildcardType = (java.lang.reflect.WildcardType)type;
        return new WildcardArgument(WildcardType.forType(wildcardType));
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown WildcardArgument forType(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType argumentType) {
        assert (argumentType instanceof WildcardType) : "argument type must be wildcard type";
        return new WildcardArgument((WildcardType)argumentType);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WildcardArgument)) {
            return false;
        }
        WildcardArgument wildcardArgument = (WildcardArgument)obj;
        return this.argumentType.equals(wildcardArgument.argumentType);
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.argumentType);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getFqName() {
        return this.argumentType.getFqName();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getBinaryName() {
        return this.argumentType.getBinaryName();
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return this.argumentType.toString();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown WildcardArgument substitute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        WildcardType argType = this.argumentType.substitute(substitution);
        if (argType.equals(this.argumentType)) {
            return this;
        }
        return new WildcardArgument(argType);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown WildcardArgument applyCaptureConversion() {
        WildcardType wildcardType = this.argumentType.applyCaptureConversion();
        if (wildcardType.equals(this.argumentType)) {
            return this;
        }
        return new WildcardArgument(wildcardType);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean contains(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeArgument argument) {
        return argument.isWildcard() && this.argumentType.contains(((WildcardArgument)argument).argumentType);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound getTypeBound() {
        return this.argumentType.getTypeBound();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable> getTypeParameters() {
        return this.argumentType.getTypeParameters();
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasUpperBound() {
        return this.argumentType.hasUpperBound();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasWildcard() {
        return true;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasCaptureVariable() {
        return false;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isGeneric(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean ignoreWildcards) {
        return this.argumentType.isGeneric(ignoreWildcards);
    }

    @Override
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isInstantiationOfTypeArgument(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeArgument otherArgument) {
        CaptureTypeVariable otherCaptureTypeVar;
        ReferenceType otherReferenceType;
        if (this.equals(otherArgument)) {
            return true;
        }
        return otherArgument instanceof ReferenceArgument && (otherReferenceType = ((ReferenceArgument)otherArgument).getReferenceType()) instanceof CaptureTypeVariable && this.equals((otherCaptureTypeVar = (CaptureTypeVariable)otherReferenceType).getWildcard());
    }

    @Override
    public @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution getInstantiatingSubstitution(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeArgument goalType) {
        ReferenceType otherReferenceType;
        if (this.equals(goalType)) {
            return new Substitution();
        }
        if (goalType instanceof WildcardArgument) {
            return this.argumentType.getInstantiatingSubstitution(((WildcardArgument)goalType).argumentType);
        }
        if (goalType instanceof ReferenceArgument && (otherReferenceType = ((ReferenceArgument)goalType).getReferenceType()) instanceof CaptureTypeVariable) {
            CaptureTypeVariable otherCaptureTypeVar = (CaptureTypeVariable)otherReferenceType;
            return this.getInstantiatingSubstitution(otherCaptureTypeVar.getWildcard());
        }
        return null;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isWildcard() {
        return true;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isVariable() {
        return false;
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown WildcardType getWildcardType() {
        return this.argumentType;
    }
}

