/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.types.ExplicitTypeVariable;
import randoop.types.JavaTypes;
import randoop.types.NullReferenceType;
import randoop.types.ParameterBound;
import randoop.types.ParameterType;
import randoop.types.ReferenceBound;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.Type;

public abstract class TypeVariable
extends ParameterType {
    TypeVariable() {
    }

    TypeVariable(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound lowerBound, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound upperBound) {
        super(lowerBound, upperBound);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable forType(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown java.lang.reflect.Type type) {
        if (!(type instanceof java.lang.reflect.TypeVariable)) {
            throw new IllegalArgumentException("type must be a type variable, got " + type);
        }
        java.lang.reflect.TypeVariable v = (java.lang.reflect.TypeVariable)type;
        HashSet variableSet = new HashSet(1);
        variableSet.add(v);
        return new ExplicitTypeVariable(v, ParameterBound.forTypes(variableSet, v.getBounds()));
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType substitute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        ReferenceType type = substitution.get(this);
        if (type != null) {
            return type;
        }
        return this;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isAssignableFrom(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type sourceType) {
        return false;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isInstantiationOf(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType otherType) {
        if (super.isInstantiationOf(otherType)) {
            return true;
        }
        if (otherType.isVariable()) {
            TypeVariable otherVariable = (TypeVariable)otherType;
            Substitution substitution = TypeVariable.getSubstitution(otherVariable, this);
            boolean lowerboundOk = otherVariable.getLowerTypeBound().isLowerBound(this.getLowerTypeBound(), substitution);
            boolean upperboundOk = otherVariable.getUpperTypeBound().isUpperBound(this.getUpperTypeBound(), substitution);
            return lowerboundOk && upperboundOk;
        }
        return false;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isSubtypeOf(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type otherType) {
        if (super.isSubtypeOf(otherType)) {
            return true;
        }
        if (otherType.isReferenceType()) {
            Substitution substitution = TypeVariable.getSubstitution(this, (ReferenceType)otherType);
            return this.getUpperTypeBound().isLowerBound(otherType, substitution);
        }
        return false;
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution getSubstitution(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable variable, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType otherType) {
        return new Substitution(variable, otherType);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isVariable() {
        return true;
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean canBeInstantiatedBy(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType otherType) {
        TypeVariable checkType;
        ParameterBound boundType;
        Substitution substitution;
        if (this.getLowerTypeBound().isVariable()) {
            substitution = TypeVariable.getSubstitution(this, otherType);
            boundType = this.getLowerTypeBound().substitute(substitution);
            checkType = (TypeVariable)((ReferenceBound)boundType).getBoundType();
            if (!checkType.canBeInstantiatedBy(otherType)) {
                return false;
            }
        } else {
            substitution = TypeVariable.getSubstitution(this, otherType);
            if (!this.getLowerTypeBound().isLowerBound(otherType, substitution)) {
                return false;
            }
        }
        if (this.getUpperTypeBound().isVariable()) {
            substitution = TypeVariable.getSubstitution(this, otherType);
            boundType = this.getUpperTypeBound().substitute(substitution);
            checkType = (TypeVariable)((ReferenceBound)boundType).getBoundType();
            if (!checkType.canBeInstantiatedBy(otherType)) {
                return false;
            }
        } else {
            substitution = TypeVariable.getSubstitution(this, otherType);
            if (!this.getUpperTypeBound().isUpperBound(otherType, substitution)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable> getTypeParameters() {
        LinkedHashSet<TypeVariable> parameters = new LinkedHashSet<TypeVariable>(super.getTypeParameters());
        parameters.add(this);
        return new ArrayList<TypeVariable>(parameters);
    }

    public abstract @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable createCopyWithBounds(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound var1, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound var2);

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type getRawtype() {
        return JavaTypes.OBJECT_TYPE;
    }

    @Override
    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        ParameterBound lowerBound = this.getLowerTypeBound();
        ParameterBound upperBound = this.getUpperTypeBound();
        StringBuilder result = new StringBuilder(this.getSimpleName());
        if (!(lowerBound instanceof ReferenceBound) || !(((ReferenceBound)lowerBound).getBoundType() instanceof NullReferenceType)) {
            result.append(" super ").append(lowerBound);
        }
        if (!(upperBound instanceof ReferenceBound) || !((ReferenceBound)upperBound).getBoundType().isObject()) {
            result.append(" super ").append(upperBound);
        }
        return result.toString();
    }
}

