/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.initialization.qual.UnknownInitialization;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.types.ExplicitTypeVariable;
import randoop.types.ReferenceType;
import randoop.types.TypeVariable;

public class Substitution {
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType> map;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType> rawMap;
    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown BiFunction<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType> requireSameEntry = (v1, v2) -> {
        if (v1 == null) {
            return v2;
        }
        if (v2 == null) {
            return v1;
        }
        if (v1.equals(v2)) {
            return v1;
        }
        throw new IllegalArgumentException(String.format("Substitutions map a key to distinct types %s and %s", v1, v2));
    };

    public Substitution() {
        this.map = new LinkedHashMap<TypeVariable, ReferenceType>();
        this.rawMap = new LinkedHashMap<Type, ReferenceType>();
    }

    public Substitution(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        this.map = new LinkedHashMap<TypeVariable, ReferenceType>(substitution.map);
        this.rawMap = new LinkedHashMap<Type, ReferenceType>(substitution.rawMap);
    }

    public Substitution(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable parameter, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType argument) {
        this();
        this.put(parameter, argument);
    }

    public Substitution(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable> parameters, ReferenceType ... arguments) {
        this();
        assert (parameters.size() == arguments.length) : "parameters=" + parameters + "  arguments=" + Arrays.toString(arguments);
        for (int i = 0; i < parameters.size(); ++i) {
            this.put(parameters.get(i), arguments[i]);
        }
    }

    public Substitution(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable> parameters, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType> arguments) {
        this();
        assert (parameters.size() == arguments.size());
        for (int i = 0; i < parameters.size(); ++i) {
            this.put(parameters.get(i), arguments.get(i));
        }
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Substitution)) {
            return false;
        }
        Substitution s2 = (Substitution)obj;
        return this.map.equals(s2.map);
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.map);
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return this.map.toString();
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isConsistentWith(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        for (Map.Entry<TypeVariable, ReferenceType> entry : substitution.map.entrySet()) {
            if (!this.map.containsKey(entry.getKey()) || this.get(entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        for (Map.Entry<Object, ReferenceType> entry : substitution.rawMap.entrySet()) {
            if (!this.rawMap.containsKey(entry.getKey()) || this.get((Type)entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution extend(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable> parameters, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType> arguments) {
        return this.extend(new Substitution(parameters, arguments));
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution extend(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution other) {
        Substitution result = new Substitution(this);
        for (Map.Entry<TypeVariable, ReferenceType> entry : other.map.entrySet()) {
            result.map.merge(entry.getKey(), entry.getValue(), requireSameEntry);
        }
        for (Map.Entry<Object, ReferenceType> entry : other.rawMap.entrySet()) {
            result.rawMap.merge((Type)entry.getKey(), entry.getValue(), requireSameEntry);
        }
        return result;
    }

    public @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType get(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable parameter) {
        return this.map.get(parameter);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType getOrDefault(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable parameter, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType defaultValue) {
        return this.map.getOrDefault(parameter, defaultValue);
    }

    public @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType get(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type parameter) {
        return this.rawMap.get(parameter);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable> keySet() {
        return this.map.keySet();
    }

    public void print() {
        for (Map.Entry<TypeVariable, ReferenceType> entry : this.map.entrySet()) {
            System.out.println(entry.getKey() + "(" + entry.getKey() + ") := " + entry.getValue());
        }
    }

    private void put(@UnknownInitialization Substitution this, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable typeParameter, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType type) {
        this.map.put(typeParameter, type);
        if (typeParameter instanceof ExplicitTypeVariable) {
            this.rawMap.put(((ExplicitTypeVariable)typeParameter).getReflectionTypeVariable(), type);
        }
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isEmpty() {
        return this.map.isEmpty();
    }
}

