/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import randoop.main.RandoopBug;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.CollectionsPlume;
import randoop.types.ClassOrInterfaceType;
import randoop.types.EagerReferenceBound;
import randoop.types.GenericClassType;
import randoop.types.InstantiatedType;
import randoop.types.LazyReferenceBound;
import randoop.types.ParameterBound;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeArgument;
import randoop.types.TypeVariable;
import randoop.types.WildcardArgument;
import randoop.types.WildcardType;

class LazyParameterBound
extends ParameterBound {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown java.lang.reflect.Type boundType;

    LazyParameterBound(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown java.lang.reflect.Type boundType) {
        this.boundType = boundType;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LazyParameterBound)) {
            return false;
        }
        LazyParameterBound b = (LazyParameterBound)obj;
        return this.boundType.equals(b.boundType);
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.boundType);
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return this.boundType.toString();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound substitute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        if (substitution.isEmpty()) {
            return this;
        }
        if (this.boundType instanceof java.lang.reflect.TypeVariable) {
            ReferenceType referenceType = substitution.get(this.boundType);
            if (referenceType != null) {
                if (referenceType.isVariable()) {
                    return new LazyReferenceBound(referenceType);
                }
                return new EagerReferenceBound(referenceType);
            }
            return this;
        }
        if (this.boundType instanceof ParameterizedType) {
            boolean isLazy = false;
            java.lang.reflect.Type[] actualTypeArgs = ((ParameterizedType)this.boundType).getActualTypeArguments();
            ArrayList<TypeArgument> argumentList = new ArrayList<TypeArgument>(actualTypeArgs.length);
            for (java.lang.reflect.Type parameter : actualTypeArgs) {
                TypeArgument typeArgument = LazyParameterBound.substitute(parameter, substitution);
                if (typeArgument == null) {
                    return this;
                }
                isLazy = LazyParameterBound.isTypeVariable(parameter) && typeArgument.isVariable();
                argumentList.add(typeArgument);
            }
            GenericClassType classType = GenericClassType.forClass((Class)((ParameterizedType)this.boundType).getRawType());
            InstantiatedType instantiatedType = new InstantiatedType(classType, argumentList);
            if (isLazy) {
                return new LazyReferenceBound(instantiatedType);
            }
            return new EagerReferenceBound(instantiatedType);
        }
        throw new RandoopBug("lazy parameter bounds should be either a type variable or parameterized type");
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeArgument substitute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown java.lang.reflect.Type type, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        if (type instanceof java.lang.reflect.TypeVariable) {
            ReferenceType referenceType = substitution.get(type);
            if (referenceType != null) {
                return TypeArgument.forType(referenceType);
            }
            return null;
        }
        if (type instanceof ParameterizedType) {
            List<TypeArgument> argumentList = CollectionsPlume.mapList(parameter -> LazyParameterBound.substitute(parameter, substitution), ((ParameterizedType)type).getActualTypeArguments());
            GenericClassType classType = GenericClassType.forClass((Class)((ParameterizedType)type).getRawType());
            InstantiatedType instantiatedType = new InstantiatedType(classType, argumentList);
            return TypeArgument.forType(instantiatedType);
        }
        if (type instanceof Class) {
            return TypeArgument.forType(ClassOrInterfaceType.forType(type));
        }
        if (type instanceof java.lang.reflect.WildcardType) {
            java.lang.reflect.WildcardType wildcardType = (java.lang.reflect.WildcardType)type;
            if (wildcardType.getLowerBounds().length > 0) {
                ReferenceType boundType;
                assert (wildcardType.getLowerBounds().length == 1) : "a wildcard is defined by the JLS to only have one bound";
                java.lang.reflect.Type lowerBound = wildcardType.getLowerBounds()[0];
                ParameterBound bound = lowerBound instanceof java.lang.reflect.TypeVariable ? ((boundType = substitution.get(lowerBound)) != null ? ParameterBound.forType(boundType) : new LazyParameterBound(lowerBound)) : ParameterBound.forType(new HashSet(0), lowerBound).substitute(substitution);
                return new WildcardArgument(new WildcardType(bound, false));
            }
            assert (wildcardType.getUpperBounds().length == 1) : "a wildcard is defined by the JLS to only have one bound";
            ParameterBound bound = ParameterBound.forTypes(new HashSet(0), wildcardType.getUpperBounds());
            bound = bound.substitute(substitution);
            return new WildcardArgument(new WildcardType(bound, true));
        }
        return null;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound applyCaptureConversion() {
        throw new LazyBoundException();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable> getTypeParameters() {
        return LazyParameterBound.getTypeParameters(this.boundType);
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable> getTypeParameters(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown java.lang.reflect.Type type) {
        ArrayList<TypeVariable> variableList;
        block4: {
            block5: {
                block3: {
                    variableList = new ArrayList<TypeVariable>();
                    if (!(type instanceof java.lang.reflect.TypeVariable)) break block3;
                    variableList.add(TypeVariable.forType(type));
                    break block4;
                }
                if (!(type instanceof ParameterizedType)) break block5;
                ParameterizedType pt = (ParameterizedType)type;
                for (java.lang.reflect.Type argType : pt.getActualTypeArguments()) {
                    variableList.addAll(LazyParameterBound.getTypeParameters(argType));
                }
                break block4;
            }
            if (!(type instanceof java.lang.reflect.WildcardType)) break block4;
            java.lang.reflect.WildcardType wt = (java.lang.reflect.WildcardType)type;
            for (java.lang.reflect.Type boundType : wt.getUpperBounds()) {
                variableList.addAll(LazyParameterBound.getTypeParameters(boundType));
            }
            for (java.lang.reflect.Type boundType : wt.getLowerBounds()) {
                variableList.addAll(LazyParameterBound.getTypeParameters(boundType));
            }
        }
        return variableList;
    }

    @Override
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasWildcard() {
        return LazyParameterBound.hasWildcard(this.boundType);
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasWildcard(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown java.lang.reflect.Type type) {
        if (type instanceof java.lang.reflect.WildcardType) {
            return true;
        }
        if (type instanceof java.lang.reflect.TypeVariable) {
            for (java.lang.reflect.Type bound : ((java.lang.reflect.TypeVariable)type).getBounds()) {
                if (!LazyParameterBound.hasWildcard(bound)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            for (java.lang.reflect.Type argType : pt.getActualTypeArguments()) {
                if (!LazyParameterBound.hasWildcard(argType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasCaptureVariable() {
        return LazyParameterBound.hasCaptureVariable(this.boundType);
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasCaptureVariable(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown java.lang.reflect.Type type) {
        if (type instanceof java.lang.reflect.TypeVariable) {
            for (java.lang.reflect.Type bound : ((java.lang.reflect.TypeVariable)type).getBounds()) {
                if (!LazyParameterBound.hasCaptureVariable(bound)) continue;
                return true;
            }
            return false;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            for (java.lang.reflect.Type argType : pt.getActualTypeArguments()) {
                if (!LazyParameterBound.hasCaptureVariable(argType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isGeneric(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean ignoreWildcards) {
        return true;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isLowerBound(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type argType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        ParameterBound b = this.substitute(substitution);
        if (b.equals(this)) {
            throw new IllegalArgumentException("substitution " + substitution + " does not instantiate " + this);
        }
        return b.isLowerBound(argType, substitution);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isObject() {
        return false;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isSubtypeOf(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound boundType) {
        throw new LazyBoundException();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isUpperBound(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type argType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        ParameterBound b = this.substitute(substitution);
        if (b.equals(this)) {
            throw new IllegalArgumentException("substitution " + substitution + " does not instantiate " + this);
        }
        return b.isUpperBound(argType, substitution);
    }

    @Override
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isUpperBound(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound bound, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        throw new LazyBoundException();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isVariable() {
        return this.boundType instanceof java.lang.reflect.TypeVariable;
    }

    static class LazyBoundException
    extends RuntimeException {
        private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown long serialVersionUID = 20190508L;

        LazyBoundException() {
        }
    }
}

