/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.plumelib.util.CollectionsPlume;
import randoop.types.CaptureTypeVariable;
import randoop.types.ClassOrInterfaceType;
import randoop.types.GenericClassType;
import randoop.types.NonParameterizedType;
import randoop.types.ParameterizedType;
import randoop.types.ReferenceArgument;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeArgument;
import randoop.types.TypeVariable;
import randoop.types.WildcardArgument;

public class InstantiatedType
extends ParameterizedType {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GenericClassType genericType;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeArgument> argumentList;

    InstantiatedType(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GenericClassType genericType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeArgument> argumentList) {
        if (genericType == null) {
            throw new IllegalArgumentException("instantiated type must be non-null");
        }
        this.genericType = genericType;
        this.argumentList = argumentList;
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InstantiatedType)) {
            return false;
        }
        InstantiatedType other = (InstantiatedType)obj;
        return this.genericType.equals(other.getGenericClassType()) && this.argumentList.equals(other.argumentList);
    }

    @Override
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.genericType, this.argumentList);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown InstantiatedType substitute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        List<TypeArgument> argumentList = CollectionsPlume.mapList(argument -> argument.substitute(substitution), this.argumentList);
        return (InstantiatedType)this.substitute(substitution, new InstantiatedType(this.genericType, argumentList));
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown InstantiatedType applyCaptureConversion() {
        if (!this.hasWildcard()) {
            return this;
        }
        ArrayList<ReferenceType> convertedTypeList = new ArrayList<ReferenceType>(this.argumentList.size());
        for (TypeArgument argument : this.argumentList) {
            Object convertedArgument;
            if (argument.isWildcard()) {
                convertedArgument = ((WildcardArgument)argument).applyCaptureConversion();
                convertedTypeList.add(new CaptureTypeVariable((WildcardArgument)convertedArgument));
                continue;
            }
            convertedArgument = ((ReferenceArgument)argument).getReferenceType().applyCaptureConversion();
            convertedTypeList.add((ReferenceType)convertedArgument);
        }
        Substitution substitution = new Substitution(this.genericType.getTypeParameters(), convertedTypeList);
        for (int i = 0; i < convertedTypeList.size(); ++i) {
            if (!((ReferenceType)convertedTypeList.get(i)).isCaptureVariable()) continue;
            CaptureTypeVariable captureVariable = (CaptureTypeVariable)convertedTypeList.get(i);
            captureVariable.convert(this.genericType.getTypeParameters().get(i), substitution);
        }
        List<TypeArgument> convertedArgumentList = CollectionsPlume.mapList(TypeArgument::forType, convertedTypeList);
        return (InstantiatedType)this.applyCaptureConversion(new InstantiatedType(this.genericType, convertedArgumentList));
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType> getInterfaces() {
        Substitution substitution = new Substitution(this.genericType.getTypeParameters(), this.getReferenceArguments());
        return this.genericType.getInterfaces(substitution);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GenericClassType getGenericClassType() {
        return this.genericType.getGenericClassType();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown InstantiatedType getMatchingSupertype(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GenericClassType goalType) {
        if (this.isInstantiationOf(goalType)) {
            return this;
        }
        return super.getMatchingSupertype(goalType);
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType> getReferenceArguments() {
        return CollectionsPlume.mapList(argument -> argument.isWildcard() ? ((WildcardArgument)argument).getWildcardType() : ((ReferenceArgument)argument).getReferenceType(), this.argumentList);
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> getRuntimeClass() {
        return this.genericType.getRuntimeClass();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType getSuperclass() {
        Substitution substitution = new Substitution(this.genericType.getTypeParameters(), this.getReferenceArguments());
        return this.getGenericClassType().getSuperclass(substitution);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeArgument> getTypeArguments() {
        return this.argumentList;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable> getTypeParameters() {
        LinkedHashSet<TypeVariable> paramSet = new LinkedHashSet<TypeVariable>(super.getTypeParameters());
        for (TypeArgument argument : this.argumentList) {
            List<TypeVariable> params = argument.getTypeParameters();
            paramSet.addAll(params);
        }
        return new ArrayList<TypeVariable>(paramSet);
    }

    public @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution getTypeSubstitution() {
        List<TypeArgument> typeArgs = this.getTypeArguments();
        ArrayList<ReferenceType> arguments = new ArrayList<ReferenceType>(typeArgs.size());
        for (TypeArgument arg : typeArgs) {
            if (arg.isWildcard()) continue;
            arguments.add(((ReferenceArgument)arg).getReferenceType());
        }
        Substitution substitution = null;
        if (arguments.size() == this.getTypeArguments().size()) {
            substitution = new Substitution(this.genericType.getTypeParameters(), arguments);
        }
        return substitution;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasWildcard() {
        for (TypeArgument argument : this.argumentList) {
            if (!argument.hasWildcard()) continue;
            return true;
        }
        return false;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasCaptureVariable() {
        for (TypeArgument argument : this.argumentList) {
            if (!argument.hasCaptureVariable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isAbstract() {
        return this.genericType.isAbstract();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isAssignableFrom(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type otherType) {
        if (super.isAssignableFrom(otherType)) {
            return true;
        }
        return otherType.isRawtype() && otherType.runtimeClassIs(this.getRuntimeClass());
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isGeneric(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean ignoreWildcards) {
        if (super.isGeneric(ignoreWildcards)) {
            return true;
        }
        for (TypeArgument argument : this.argumentList) {
            if (!argument.isGeneric(ignoreWildcards)) continue;
            return true;
        }
        return false;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isInstantiationOf(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType otherType) {
        if (super.isInstantiationOf(otherType) && !(otherType instanceof InstantiatedType)) {
            return true;
        }
        if (otherType instanceof InstantiatedType) {
            InstantiatedType otherInstType = (InstantiatedType)otherType;
            if (!this.getGenericClassType().equals(otherInstType.getGenericClassType())) {
                return false;
            }
            for (int i = 0; i < this.argumentList.size(); ++i) {
                TypeArgument otherTypeArg;
                TypeArgument thisTypeArg = this.argumentList.get(i);
                if (thisTypeArg.isInstantiationOfTypeArgument(otherTypeArg = otherInstType.argumentList.get(i))) continue;
                return false;
            }
            return true;
        }
        if (otherType instanceof GenericClassType) {
            GenericClassType otherGenClass = (GenericClassType)otherType;
            return this.getGenericClassType().equals(otherGenClass);
        }
        return super.isInstantiationOf(otherType);
    }

    @Override
    public @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution getInstantiatingSubstitution(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType goalType) {
        Substitution superResult = ReferenceType.getInstantiatingSubstitutionforTypeVariable(this, goalType);
        if (superResult != null) {
            return superResult;
        }
        assert (goalType.isGeneric());
        Substitution substitution = super.getInstantiatingSubstitution(goalType);
        if (goalType instanceof InstantiatedType) {
            InstantiatedType otherInstType = (InstantiatedType)goalType;
            if (this.getGenericClassType().equals(otherInstType.getGenericClassType())) {
                for (int i = 0; i < this.argumentList.size(); ++i) {
                    TypeArgument otherTArg;
                    TypeArgument thisTArg = this.argumentList.get(i);
                    Substitution subst = thisTArg.getInstantiatingSubstitution(otherTArg = otherInstType.argumentList.get(i));
                    if (subst == null) {
                        return null;
                    }
                    substitution = substitution.extend(subst);
                }
                return substitution;
            }
            return null;
        }
        if (goalType instanceof GenericClassType) {
            return substitution;
        }
        return null;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isInterface() {
        return this.genericType.isInterface();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isParameterized() {
        return true;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isRecursiveType() {
        if (this.argumentList.size() > 1 || this.argumentList.get(0).hasWildcard()) {
            return false;
        }
        ReferenceType argType = ((ReferenceArgument)this.argumentList.get(0)).getReferenceType();
        return argType.isSubtypeOf(this);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isStatic() {
        return this.genericType.isStatic();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isSubtypeOf(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type otherType) {
        if (otherType.isParameterized()) {
            InstantiatedType otherInstandiatedType;
            InstantiatedType superType;
            if (otherType.runtimeClassIs(this.getRuntimeClass())) {
                int i;
                InstantiatedType otherInstantiatedType = (InstantiatedType)otherType;
                List<TypeArgument> otherTypeArguments = otherInstantiatedType.getTypeArguments();
                List<TypeArgument> thisTypeArguments = this.getTypeArguments();
                assert (otherTypeArguments.size() == thisTypeArguments.size());
                for (i = 0; i < thisTypeArguments.size() && otherTypeArguments.get(i).contains(thisTypeArguments.get(i)); ++i) {
                }
                if (i == thisTypeArguments.size()) {
                    return true;
                }
            }
            if ((superType = this.getMatchingSupertype((otherInstandiatedType = (InstantiatedType)otherType).getGenericClassType())) != null && superType.equals(otherType)) {
                return true;
            }
        }
        if (super.isSubtypeOf(otherType)) {
            return true;
        }
        if (this.hasWildcard()) {
            return this.applyCaptureConversion().isSubtypeOf(otherType);
        }
        return this.getRawtype().isSubtypeOf(otherType);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown NonParameterizedType getRawtype() {
        return this.genericType.getRawtype();
    }
}

