/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.plumelib.util.CollectionsPlume;
import randoop.types.ClassOrInterfaceType;
import randoop.types.InstantiatedType;
import randoop.types.JavaTypes;
import randoop.types.NonParameterizedType;
import randoop.types.ParameterizedType;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeArgument;
import randoop.types.TypeVariable;

public class GenericClassType
extends ParameterizedType {
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> rawType;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable> parameters;

    GenericClassType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> rawType) {
        this.rawType = rawType;
        this.parameters = CollectionsPlume.mapList(TypeVariable::forType, rawType.getTypeParameters());
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericClassType)) {
            return false;
        }
        GenericClassType t2 = (GenericClassType)obj;
        return this.rawType.equals(t2.rawType);
    }

    @Override
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.rawType);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown InstantiatedType substitute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        List<TypeArgument> argumentList = CollectionsPlume.mapList(variable -> TypeArgument.forType(substitution.getOrDefault((TypeVariable)variable, (ReferenceType)variable)), this.parameters);
        return (InstantiatedType)this.substitute(substitution, new InstantiatedType(new GenericClassType(this.rawType), argumentList));
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GenericClassType applyCaptureConversion() {
        return (GenericClassType)this.applyCaptureConversion(this);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType> getInterfaces() {
        return CollectionsPlume.mapList(ClassOrInterfaceType::forClass, this.rawType.getInterfaces());
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType> getInterfaces(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        return CollectionsPlume.mapList(type -> ClassOrInterfaceType.forType(type).substitute(substitution), this.rawType.getGenericInterfaces());
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GenericClassType getGenericClassType() {
        return this;
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> getRuntimeClass() {
        return this.rawType;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType getSuperclass() {
        Class<?> superclass = this.rawType.getSuperclass();
        if (superclass != null) {
            return ClassOrInterfaceType.forClass(superclass);
        }
        return JavaTypes.OBJECT_TYPE;
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType getSuperclass(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        java.lang.reflect.Type superclass = this.rawType.getGenericSuperclass();
        if (superclass == null) {
            return JavaTypes.OBJECT_TYPE;
        }
        return ClassOrInterfaceType.forType(superclass).substitute(substitution);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeArgument> getTypeArguments() {
        return CollectionsPlume.mapList(TypeArgument::forType, this.parameters);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable> getTypeParameters() {
        List<TypeVariable> params = super.getTypeParameters();
        params.addAll(this.parameters);
        return params;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown InstantiatedType instantiate(ReferenceType ... typeArguments) {
        if (typeArguments.length != this.getTypeParameters().size()) {
            throw new IllegalArgumentException("number of arguments and parameters must match");
        }
        Substitution substitution = new Substitution(this.getTypeParameters(), typeArguments);
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (this.parameters.get(i).getUpperTypeBound().isUpperBound(typeArguments[i], substitution)) continue;
            throw new IllegalArgumentException("type argument " + typeArguments[i] + " does not match parameter bound " + this.parameters.get(i).getUpperTypeBound());
        }
        return this.substitute(substitution);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown InstantiatedType instantiate(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType> typeArguments) {
        if (typeArguments.size() != this.getTypeParameters().size()) {
            throw new IllegalArgumentException("number of arguments and parameters must match");
        }
        Substitution substitution = new Substitution(this.getTypeParameters(), typeArguments);
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (this.parameters.get(i).getUpperTypeBound().isUpperBound(typeArguments.get(i), substitution)) continue;
            throw new IllegalArgumentException("type argument " + typeArguments.get(i) + " does not match parameter bound " + this.parameters.get(i).getUpperTypeBound());
        }
        return this.substitute(substitution);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isAbstract() {
        return Modifier.isAbstract(Modifier.classModifiers() & this.rawType.getModifiers());
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isGeneric(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean ignoreWildcards) {
        return true;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isInterface() {
        return this.rawType.isInterface();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isStatic() {
        return Modifier.isStatic(this.rawType.getModifiers() & Modifier.classModifiers());
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isSubtypeOf(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type otherType) {
        if (otherType == null) {
            throw new IllegalArgumentException("type must be non-null");
        }
        if (super.isSubtypeOf(otherType)) {
            return true;
        }
        return otherType.isRawtype() && otherType.runtimeClassIs(this.getRuntimeClass());
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown NonParameterizedType getRawtype() {
        return NonParameterizedType.forClass(this.rawType);
    }
}

