/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.plumelib.util.StringsPlume;
import randoop.types.GenericClassType;
import randoop.types.InstantiatedType;
import randoop.types.NonParameterizedType;
import randoop.types.ParameterizedType;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeArgument;
import randoop.types.TypeVariable;

public abstract class ClassOrInterfaceType
extends ReferenceType {
    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean debug = false;
    protected @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType enclosingType = null;

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType forClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> classType) {
        if (classType.isArray() || classType.isPrimitive()) {
            throw new IllegalArgumentException("type must be a class or interface, got " + classType);
        }
        ClassOrInterfaceType type = classType.getTypeParameters().length > 0 ? ParameterizedType.forClass(classType) : NonParameterizedType.forClass(classType);
        Class<?> enclosingClass = classType.getEnclosingClass();
        if (enclosingClass != null) {
            type.enclosingType = ClassOrInterfaceType.forClass(enclosingClass);
        }
        return type;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType forType(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown java.lang.reflect.Type type) {
        if (type instanceof java.lang.reflect.ParameterizedType) {
            java.lang.reflect.ParameterizedType t2 = (java.lang.reflect.ParameterizedType)type;
            Class rawType = (Class)t2.getRawType();
            if (rawType.getTypeParameters().length == 0) {
                return ClassOrInterfaceType.forClass(rawType);
            }
            return ParameterizedType.forType(t2);
        }
        if (type instanceof Class) {
            Class classType = (Class)type;
            return new NonParameterizedType(classType);
        }
        throw new IllegalArgumentException("Unable to create class type from type " + type);
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ClassOrInterfaceType)) {
            return false;
        }
        ClassOrInterfaceType otherType = (ClassOrInterfaceType)obj;
        return !this.isNestedClass() || !otherType.isNestedClass() || this.enclosingType.equals(otherType.enclosingType);
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.enclosingType);
    }

    @Override
    public abstract @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType substitute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution var1);

    final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType substitute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType type) {
        if (this.isMemberClass()) {
            type.enclosingType = this.enclosingType.substitute(substitution);
        }
        return type;
    }

    @Override
    public abstract @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType applyCaptureConversion();

    final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType applyCaptureConversion(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType type) {
        if (this.isMemberClass()) {
            type.enclosingType = this.enclosingType.applyCaptureConversion();
        }
        return type;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getSimpleName() {
        return this.getRuntimeClass().getSimpleName();
    }

    @Override
    public @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getCanonicalName() {
        return this.getRuntimeClass().getCanonicalName();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getFqName() {
        if (this.isNestedClass()) {
            if (this.isStatic()) {
                return this.enclosingType.getCanonicalName() + "." + this.getSimpleName();
            }
            return this.enclosingType.getFqName() + "." + this.getSimpleName();
        }
        return this.getCanonicalName();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getBinaryName() {
        if (this.isNestedClass()) {
            if (this.isStatic()) {
                return this.enclosingType.getBinaryName().replaceAll("<[^<]*>$", "") + "$" + this.getSimpleName();
            }
            return this.enclosingType.getBinaryName() + "$" + this.getSimpleName();
        }
        return this.getRuntimeClass().getName();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getUnqualifiedBinaryName() {
        String prefix = "";
        if (this.isNestedClass()) {
            prefix = this.enclosingType.getUnqualifiedBinaryName() + "$";
        }
        return prefix + this.getSimpleName();
    }

    public abstract @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType> getInterfaces();

    public @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Package getPackage() {
        Class<?> c = this.getRuntimeClass();
        if (c == null) {
            throw new IllegalArgumentException("Class " + this.toString() + " has no runtime class");
        }
        return c.getPackage();
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getPackagePrefix() {
        Package pkg = this.getPackage();
        if (pkg == null) {
            return "";
        }
        return pkg.getName() + ".";
    }

    @Override
    public abstract @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown NonParameterizedType getRawtype();

    public @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown InstantiatedType getMatchingSupertype(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GenericClassType goalType) {
        ClassOrInterfaceType superclass;
        if (goalType.isInterface()) {
            for (ClassOrInterfaceType interfaceType : this.getInterfaces()) {
                if (!goalType.getRuntimeClass().isAssignableFrom(interfaceType.getRuntimeClass())) continue;
                if (interfaceType.isParameterized()) {
                    InstantiatedType type = (InstantiatedType)interfaceType;
                    if (type.isInstantiationOf(goalType)) {
                        return (InstantiatedType)interfaceType;
                    }
                    InstantiatedType result = type.getMatchingSupertype(goalType);
                    if (result == null) continue;
                    return result;
                }
                return interfaceType.getMatchingSupertype(goalType);
            }
        }
        if ((superclass = this.getSuperclass()) != null && !superclass.isObject() && goalType.getRuntimeClass().isAssignableFrom(superclass.getRuntimeClass())) {
            if (superclass.isInstantiationOf(goalType)) {
                return (InstantiatedType)superclass;
            }
            return superclass.getMatchingSupertype(goalType);
        }
        return null;
    }

    @Override
    public @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution getInstantiatingSubstitution(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType goalType) {
        InstantiatedType supertype;
        Substitution superResult = ReferenceType.getInstantiatingSubstitutionforTypeVariable(this, goalType);
        if (superResult != null) {
            return superResult;
        }
        assert (goalType.isGeneric()) : "goal type must be generic";
        Substitution substitution = new Substitution();
        if (this.isMemberClass() && (substitution = this.enclosingType.getInstantiatingSubstitution(goalType)) == null) {
            return null;
        }
        if (goalType instanceof GenericClassType && (supertype = this.getMatchingSupertype((GenericClassType)goalType)) != null) {
            Substitution supertypeSubstitution = supertype.getTypeSubstitution();
            if (supertypeSubstitution == null) {
                return null;
            }
            substitution = substitution.extend(supertypeSubstitution);
        }
        return substitution;
    }

    public abstract @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType getSuperclass();

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Collection<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType> getSuperTypes() {
        ArrayList<ClassOrInterfaceType> supertypes = new ArrayList<ClassOrInterfaceType>();
        if (this.isObject()) {
            return supertypes;
        }
        ClassOrInterfaceType superclass = this.getSuperclass();
        if (superclass != null) {
            supertypes.add(superclass);
            supertypes.addAll(superclass.getSuperTypes());
        }
        for (ClassOrInterfaceType interfaceType : this.getInterfaces()) {
            supertypes.add(interfaceType);
            supertypes.addAll(interfaceType.getSuperTypes());
        }
        return supertypes;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType> getImmediateSupertypes() {
        if (this.isObject()) {
            return Collections.emptyList();
        }
        ClassOrInterfaceType superclass = this.getSuperclass();
        List<ClassOrInterfaceType> interfaces = this.getInterfaces();
        ArrayList<ClassOrInterfaceType> supertypes = new ArrayList<ClassOrInterfaceType>(interfaces.size() + 1);
        supertypes.add(superclass);
        supertypes.addAll(interfaces);
        return supertypes;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Collection<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType> getAllSupertypesInclusive() {
        LinkedHashSet<ClassOrInterfaceType> result = new LinkedHashSet<ClassOrInterfaceType>();
        ArrayDeque<ClassOrInterfaceType> worklist = new ArrayDeque<ClassOrInterfaceType>();
        worklist.add(this);
        while (!worklist.isEmpty()) {
            ClassOrInterfaceType type = (ClassOrInterfaceType)worklist.remove();
            if (!result.add(type)) continue;
            worklist.addAll(type.getImmediateSupertypes());
        }
        return result;
    }

    public abstract @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isAbstract();

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isGeneric(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean ignoreWildcards) {
        return this.isMemberClass() && this.enclosingType.isGeneric(ignoreWildcards);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isInstantiationOf(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType otherType) {
        if (super.isInstantiationOf(otherType)) {
            return true;
        }
        if (this.isNestedClass() && otherType instanceof ClassOrInterfaceType) {
            ClassOrInterfaceType otherClassType = (ClassOrInterfaceType)otherType;
            return otherClassType.isNestedClass() && this.enclosingType.isInstantiationOf(otherClassType.enclosingType);
        }
        return false;
    }

    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isNestedClass() {
        return this.enclosingType != null;
    }

    public final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isMemberClass() {
        return this.isNestedClass() && !this.isStatic();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isParameterized() {
        return this.isMemberClass() && this.enclosingType.isParameterized();
    }

    public abstract @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isStatic();

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isSubtypeOf(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type otherType) {
        if (debug) {
            System.out.printf("isSubtypeOf(%s, %s) [%s, %s]%n", this, otherType, this.getClass(), otherType.getClass());
        }
        if (otherType.isObject()) {
            return true;
        }
        if (super.isSubtypeOf(otherType)) {
            return true;
        }
        if (this instanceof NonParameterizedType && otherType.isGeneric() && this.getRuntimeClass() == otherType.getRuntimeClass()) {
            return true;
        }
        if (!otherType.isReferenceType()) {
            return false;
        }
        if (otherType.isInterface()) {
            for (ClassOrInterfaceType iface : this.getInterfaces()) {
                if (debug) {
                    System.out.printf("  iface: %s%n", StringsPlume.toStringAndClass(iface));
                }
                if (iface.equals(otherType)) {
                    return true;
                }
                if (!iface.isSubtypeOf(otherType)) continue;
                return true;
            }
        }
        if (this.isInterface()) {
            return false;
        }
        ClassOrInterfaceType superClassType = this.getSuperclass();
        if (debug) {
            System.out.printf("  superClassType: %s%n", superClassType);
        }
        if (superClassType == null || superClassType.isObject()) {
            return false;
        }
        return superClassType.isSubtypeOf(otherType);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasWildcard() {
        return false;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasCaptureVariable() {
        return false;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeArgument> getTypeArguments() {
        return new ArrayList<TypeArgument>(0);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable> getTypeParameters() {
        if (this.isMemberClass()) {
            return this.enclosingType.getTypeParameters();
        }
        return new ArrayList<TypeVariable>(0);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isClassOrInterfaceType() {
        return true;
    }
}

