/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.util.ArrayList;
import java.util.Objects;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.types.IntersectionTypeBound;
import randoop.types.ParameterBound;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.TypeVariable;
import randoop.types.WildcardArgument;

class CaptureTypeVariable
extends TypeVariable {
    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int count = 0;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int varID;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown WildcardArgument wildcard;

    CaptureTypeVariable(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown WildcardArgument wildcard) {
        this.varID = count++;
        this.wildcard = wildcard;
        if (wildcard.hasUpperBound()) {
            this.setUpperBound(wildcard.getTypeBound());
        } else {
            this.setLowerBound(wildcard.getTypeBound());
        }
    }

    private CaptureTypeVariable(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int varID, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown WildcardArgument wildcard, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound lowerBound, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound upperBound) {
        super(lowerBound, upperBound);
        this.varID = varID;
        this.wildcard = wildcard;
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown WildcardArgument getWildcard() {
        return this.wildcard;
    }

    @Override
    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CaptureTypeVariable)) {
            return false;
        }
        CaptureTypeVariable variable = (CaptureTypeVariable)obj;
        return this.varID == variable.varID && this.wildcard.equals(variable.wildcard) && super.equals(variable);
    }

    @Override
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.varID, this.wildcard, super.hashCode());
    }

    @Override
    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return this.getBinaryName() + " of " + this.wildcard;
    }

    public void convert(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable typeParameter, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        ParameterBound parameterBound = typeParameter.getUpperTypeBound().substitute(substitution);
        if (this.getUpperTypeBound().isObject()) {
            this.setUpperBound(parameterBound);
        } else {
            ArrayList<ParameterBound> boundList = new ArrayList<ParameterBound>(2);
            boundList.add(parameterBound);
            boundList.add(this.getUpperTypeBound());
            this.setUpperBound(new IntersectionTypeBound(boundList));
        }
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getFqName() {
        return "Capture" + this.varID;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getBinaryName() {
        return "Capture" + this.varID;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getSimpleName() {
        return this.getFqName();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isCaptureVariable() {
        return true;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasCaptureVariable() {
        return true;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isGeneric(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean ignoreWildcards) {
        return !ignoreWildcards;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceType substitute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        ReferenceType type = substitution.get(this);
        if (type != null && !type.isVariable()) {
            return type;
        }
        ParameterBound lowerBound = this.getLowerTypeBound().substitute(substitution);
        ParameterBound upperBound = this.getUpperTypeBound().substitute(substitution);
        if (type == null) {
            if (!lowerBound.equals(this.getLowerTypeBound()) || !upperBound.equals(this.getUpperTypeBound())) {
                WildcardArgument updatedWildcard = this.wildcard.substitute(substitution);
                return new CaptureTypeVariable(this.varID, updatedWildcard, lowerBound, upperBound);
            }
            return this;
        }
        if (!lowerBound.equals(this.getLowerTypeBound()) || !upperBound.equals(this.getUpperTypeBound())) {
            return ((TypeVariable)type).createCopyWithBounds(lowerBound, upperBound);
        }
        return type;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable createCopyWithBounds(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound lowerBound, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ParameterBound upperBound) {
        return new CaptureTypeVariable(this.varID, this.wildcard, lowerBound, upperBound);
    }
}

