/*
 * Decompiled with CFR 0.152.
 */
package randoop.types;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.types.ClassOrInterfaceType;
import randoop.types.JavaTypes;
import randoop.types.ReferenceType;
import randoop.types.Substitution;
import randoop.types.Type;
import randoop.types.TypeVariable;

public class ArrayType
extends ReferenceType {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type componentType;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> runtimeClass;

    private ArrayType(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type componentType, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> runtimeClass) {
        this.componentType = componentType;
        this.runtimeClass = runtimeClass;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ArrayType forClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> arrayClass) {
        if (!arrayClass.isArray()) {
            throw new IllegalArgumentException("type must be an array");
        }
        Type componentType = Type.forClass(arrayClass.getComponentType());
        return new ArrayType(componentType, arrayClass);
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ArrayType forType(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown java.lang.reflect.Type type) {
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Type componentType = Type.forType(arrayType.getGenericComponentType());
            return ArrayType.ofComponentType(componentType);
        }
        if (type instanceof Class && ((Class)type).isArray()) {
            Type componentType = Type.forType(((Class)type).getComponentType());
            return ArrayType.ofComponentType(componentType);
        }
        throw new IllegalArgumentException("type " + type + " must be an array type");
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ArrayType ofComponentType(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type componentType) {
        if (componentType instanceof TypeVariable) {
            return new ArrayType(componentType, Array.newInstance(Object.class, 0).getClass());
        }
        return new ArrayType(componentType, Array.newInstance(componentType.getRuntimeClass(), 0).getClass());
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArrayType)) {
            return false;
        }
        ArrayType t2 = (ArrayType)obj;
        return this.componentType.equals(t2.componentType) && this.runtimeClass.equals(t2.runtimeClass);
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.componentType, this.runtimeClass);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ArrayType substitute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Substitution substitution) {
        Type type = this.componentType.substitute(substitution);
        if (!type.equals(this)) {
            return ArrayType.ofComponentType(type);
        }
        return this;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type getComponentType() {
        return this.componentType;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type getElementType() {
        if (this.componentType.isArray()) {
            return ((ArrayType)this.componentType).getElementType();
        }
        return this.componentType;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getFqName() {
        return this.componentType.getFqName() + "[]";
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getBinaryName() {
        return this.componentType.getBinaryName() + "[]";
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String getSimpleName() {
        return this.componentType.getSimpleName() + "[]";
    }

    @Override
    @Pure
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> getRuntimeClass() {
        return this.runtimeClass;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypeVariable> getTypeParameters() {
        if (this.componentType.isReferenceType()) {
            return ((ReferenceType)this.componentType).getTypeParameters();
        }
        return new ArrayList<TypeVariable>(2);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isArray() {
        return true;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isAssignableFrom(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type otherType) {
        if (super.isAssignableFrom(otherType)) {
            return true;
        }
        if (otherType.isArray() && this.componentType.isParameterized()) {
            Type otherElementType = ((ArrayType)otherType).componentType;
            return otherElementType.isRawtype() && otherElementType.runtimeClassIs(this.componentType.getRuntimeClass());
        }
        return false;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isGeneric(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean ignoreWildcards) {
        return this.componentType.isGeneric(ignoreWildcards);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isSubtypeOf(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type otherType) {
        if (super.isSubtypeOf(otherType)) {
            return true;
        }
        if (otherType.equals(JavaTypes.CLONEABLE_TYPE)) {
            return true;
        }
        if (otherType.equals(JavaTypes.SERIALIZABLE_TYPE)) {
            return true;
        }
        if (otherType.isArray() && this.componentType.isReferenceType()) {
            ArrayType otherArrayType = (ArrayType)otherType;
            return otherArrayType.componentType.isReferenceType() && this.componentType.isSubtypeOf(otherArrayType.componentType);
        }
        return false;
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type getRawtype() {
        if (!this.componentType.isGeneric()) {
            return this;
        }
        return new ArrayType(this.componentType.getRawtype(), this.runtimeClass);
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasWildcard() {
        return this.componentType.hasWildcard();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasCaptureVariable() {
        return this.componentType.hasCaptureVariable();
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasParameterizedElementType() {
        return this.getElementType().isParameterized();
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ArrayType getRawTypeArray() {
        ReferenceType rawElementType;
        if (this.componentType.isArray()) {
            rawElementType = ((ArrayType)this.componentType).getRawTypeArray();
        } else if (this.componentType.isClassOrInterfaceType()) {
            rawElementType = ((ClassOrInterfaceType)this.componentType).getRawtype();
        } else {
            return this;
        }
        return ArrayType.ofComponentType(rawElementType);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int getDimensions() {
        int dimensions = 1;
        if (this.componentType.isArray()) {
            dimensions += ((ArrayType)this.componentType).getDimensions();
        }
        return dimensions;
    }
}

