/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import java.util.concurrent.TimeoutException;
import randoop.ExceptionalExecution;
import randoop.ExecutionOutcome;
import randoop.main.ExceptionBehaviorClassifier;
import randoop.main.GenInputsAbstract;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.sequence.ExecutableSequence;
import randoop.sequence.SequenceExceptionError;
import randoop.test.InvalidChecks;
import randoop.test.InvalidExceptionCheck;
import randoop.test.TestCheckGenerator;

public class ValidityCheckingGenerator
extends TestCheckGenerator {
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean throwExceptionOnFlakyTest;

    public ValidityCheckingGenerator(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean throwExceptionOnFlakyTest) {
        this.throwExceptionOnFlakyTest = throwExceptionOnFlakyTest;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown InvalidChecks generateTestChecks(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSequence eseq) {
        int finalIndex = eseq.sequence.size() - 1;
        for (int i = 0; i < eseq.sequence.size(); ++i) {
            ExecutionOutcome result = eseq.getResult(i);
            if (!(result instanceof ExceptionalExecution)) continue;
            ExceptionalExecution exec = (ExceptionalExecution)result;
            Throwable e = exec.getException();
            if (i != finalIndex) {
                if (this.throwExceptionOnFlakyTest && !(e instanceof OutOfMemoryError) && !(e instanceof StackOverflowError) && !(e instanceof TimeoutException)) {
                    throw new SequenceExceptionError(eseq, i, e);
                }
                return new InvalidChecks(new InvalidExceptionCheck(e, i, e.getClass().getName()));
            }
            if (ExceptionBehaviorClassifier.classify(exec, eseq) != GenInputsAbstract.BehaviorType.INVALID) continue;
            return new InvalidChecks(new InvalidExceptionCheck(e, i, e.getClass().getName()));
        }
        return InvalidChecks.EMPTY;
    }
}

