/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Set;
import randoop.ExceptionalExecution;
import randoop.ExecutionOutcome;
import randoop.NormalExecution;
import randoop.NotExecuted;
import randoop.contract.EnumValue;
import randoop.contract.IsNotNull;
import randoop.contract.IsNull;
import randoop.contract.ObserverEqArray;
import randoop.contract.ObserverEqValue;
import randoop.contract.PrimValue;
import randoop.operation.TypedClassOperation;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.plumelib.util.StringsPlume;
import randoop.reflection.AccessibilityPredicate;
import randoop.reflection.OmitMethodsPredicate;
import randoop.sequence.ExecutableSequence;
import randoop.sequence.Statement;
import randoop.sequence.Value;
import randoop.sequence.Variable;
import randoop.test.ExpectedExceptionCheckGen;
import randoop.test.ObjectCheck;
import randoop.test.RegressionChecks;
import randoop.test.TestCheckGenerator;
import randoop.types.PrimitiveTypes;
import randoop.types.Type;
import randoop.util.Log;
import randoop.util.MultiMap;

public final class RegressionCaptureGenerator
extends TestCheckGenerator {
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExpectedExceptionCheckGen exceptionExpectation;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MultiMap<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation> sideEffectFreeMethodsByType;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate isAccessible;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OmitMethodsPredicate omitMethodsPredicate;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean includeAssertions;
    private static final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int MAX_ARRAY_LENGTH = 25;

    public RegressionCaptureGenerator(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExpectedExceptionCheckGen exceptionExpectation, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown MultiMap<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation> sideEffectFreeMethodsByType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate isAccessible, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OmitMethodsPredicate omitMethodsPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean includeAssertions) {
        this.exceptionExpectation = exceptionExpectation;
        this.sideEffectFreeMethodsByType = sideEffectFreeMethodsByType;
        this.isAccessible = isAccessible;
        this.omitMethodsPredicate = omitMethodsPredicate;
        this.includeAssertions = includeAssertions;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown RegressionChecks generateTestChecks(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSequence eseq) {
        RegressionChecks checks = new RegressionChecks();
        int finalIndex = eseq.sequence.size() - 1;
        for (int i = 0; i < eseq.sequence.size(); ++i) {
            Statement statement = eseq.sequence.getStatement(i);
            ExecutionOutcome result = eseq.getResult(i);
            if (result instanceof NotExecuted) {
                throw new Error("Abnormal execution in sequence: " + eseq);
            }
            if (result instanceof NormalExecution) {
                Variable var0;
                Set<TypedClassOperation> sideEffectFreeMethods;
                Type outputType;
                if (!this.includeAssertions) continue;
                NormalExecution execution = (NormalExecution)result;
                if (statement.isNonreceivingInitialization() || (outputType = statement.getOutputType()).isVoid()) continue;
                Object runtimeValue = execution.getRuntimeValue();
                Variable var = eseq.sequence.getVariable(i);
                if (runtimeValue == null) {
                    checks.add(new ObjectCheck(new IsNull(), var));
                    continue;
                }
                if (PrimitiveTypes.isBoxedPrimitive(runtimeValue.getClass()) || runtimeValue.getClass().equals(String.class)) {
                    if (Value.isUnassertableString(runtimeValue)) continue;
                    PrimValue.EqualityMode equalityMode = var.getType().isPrimitive() || var.getType().isBoxedPrimitive() ? PrimValue.EqualityMode.EQUALSEQUALS : PrimValue.EqualityMode.EQUALSMETHOD;
                    ObjectCheck oc = new ObjectCheck(new PrimValue(runtimeValue, equalityMode), var);
                    checks.add(oc);
                    continue;
                }
                if (runtimeValue.getClass().isEnum() && this.isAccessible.isAccessible(runtimeValue.getClass())) {
                    ObjectCheck oc = new ObjectCheck(new EnumValue((Enum)runtimeValue), var);
                    checks.add(oc);
                    continue;
                }
                if (runtimeValue.getClass().isArray() && ObserverEqArray.isLiteralType(runtimeValue, this.isAccessible)) {
                    if (!statement.isConstructorCall()) {
                        checks.add(new ObjectCheck(new IsNotNull(), var));
                    }
                    if (Array.getLength(runtimeValue) > 25) continue;
                    ObserverEqArray observerEqArray = new ObserverEqArray(runtimeValue, this.isAccessible);
                    ObjectCheck observerCheck = new ObjectCheck(observerEqArray, var);
                    checks.add(observerCheck);
                    continue;
                }
                if (!statement.isConstructorCall()) {
                    checks.add(new ObjectCheck(new IsNotNull(), var));
                }
                if ((sideEffectFreeMethods = this.sideEffectFreeMethodsByType.getValues((var0 = eseq.sequence.getVariable(i)).getType())) == null) continue;
                for (TypedClassOperation m4 : sideEffectFreeMethods) {
                    Object value;
                    ExecutionOutcome outcome;
                    if (!RegressionCaptureGenerator.isAssertableMethod(m4, this.omitMethodsPredicate, this.isAccessible) || RegressionCaptureGenerator.isObjectToString(m4) && runtimeValue.getClass() == Object.class || (outcome = m4.execute(new Object[]{runtimeValue})) instanceof ExceptionalExecution || Value.isUnassertableString(value = ((NormalExecution)outcome).getRuntimeValue())) continue;
                    ObserverEqValue observerEqValue = new ObserverEqValue(m4, value);
                    ObjectCheck observerCheck = new ObjectCheck(observerEqValue, var);
                    Log.logPrintf("Adding observer check %s%n", observerCheck);
                    checks.add(observerCheck);
                }
                continue;
            }
            if (result instanceof ExceptionalExecution) {
                if (i != finalIndex) {
                    throw new Error("Exception thrown before end of sequence");
                }
                ExceptionalExecution e = (ExceptionalExecution)result;
                checks.add(this.exceptionExpectation.getExceptionCheck(e, eseq, i));
                continue;
            }
            throw new Error("Unexpected result type: " + StringsPlume.toStringAndClass(result));
        }
        return checks;
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isObjectToString(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation m4) {
        Class<?> declaringClass = m4.getDeclaringType().getRuntimeClass();
        if (declaringClass == Object.class || declaringClass == Objects.class) {
            return m4.getUnqualifiedBinaryName().equals("toString");
        }
        if (declaringClass == String.class) {
            return m4.getUnqualifiedBinaryName().equals("valueOf");
        }
        return false;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isAssertableMethod(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedClassOperation m4, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown OmitMethodsPredicate omitMethodsPredicate, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate accessibility) {
        if (omitMethodsPredicate.shouldOmit(m4)) {
            return false;
        }
        AccessibleObject executable = m4.getOperation().getReflectionObject();
        if (executable instanceof Method) {
            if (!accessibility.isAccessible((Method)executable)) {
                return false;
            }
        } else if (executable instanceof Constructor) {
            if (!accessibility.isAccessible((Constructor)executable)) {
                return false;
            }
        } else {
            throw new IllegalArgumentException("TypedClassOperation " + m4 + " must be either of type Constructor or Method.");
        }
        if (m4.getInputTypes().size() != 1) {
            return false;
        }
        if (m4.getOutputType().isVoid()) {
            return false;
        }
        Class<?> outputClass = m4.getOutputType().getRuntimeClass();
        if (outputClass == null) {
            return false;
        }
        return PrimitiveTypes.isBoxedPrimitive(outputClass) || outputClass.equals(String.class) || outputClass.isEnum();
    }
}

