/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import java.util.Arrays;
import java.util.Objects;
import randoop.contract.ObjectContract;
import randoop.contract.ObjectContractUtils;
import randoop.main.RandoopBug;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.org.plumelib.util.StringsPlume;
import randoop.sequence.Variable;
import randoop.test.Check;

public class ObjectCheck
implements Check {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ObjectContract contract;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] vars;

    public ObjectCheck(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ObjectContract contract, Variable ... vars) {
        if (contract == null) {
            throw new IllegalArgumentException("first argument cannot be null.");
        }
        if (vars.length != contract.getArity()) {
            throw new IllegalArgumentException("vars.size() != template.getArity().");
        }
        this.contract = contract;
        this.vars = new Variable[vars.length];
        int count = 0;
        for (Variable v : vars) {
            this.vars[count++] = v;
        }
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectCheck)) {
            return false;
        }
        ObjectCheck other = (ObjectCheck)o;
        return this.contract.equals(other.contract) && Arrays.equals(this.vars, other.vars);
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.contract, Arrays.hashCode(this.vars));
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        return "<check: " + this.contract.toString() + " " + StringsPlume.escapeJava(Arrays.toString(this.vars)) + ">";
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toCodeStringPreStatement() {
        return "";
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toCodeStringPostStatement() {
        try {
            return ObjectContractUtils.localizeContractCode(this.contract.toCodeString(), this.vars);
        }
        catch (Exception e) {
            throw new RandoopBug("Problem with ObjectCheck " + this, e);
        }
    }
}

