/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import java.util.List;
import randoop.ExceptionalExecution;
import randoop.ExecutionOutcome;
import randoop.NotExecuted;
import randoop.condition.ThrowsClause;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.sequence.ExecutableSequence;
import randoop.test.ErrorRevealingChecks;
import randoop.test.ExpectedExceptionCheck;
import randoop.test.MissingExceptionCheck;
import randoop.test.RegressionChecks;
import randoop.test.TestCheckGenerator;
import randoop.test.TestChecks;
import randoop.types.ClassOrInterfaceType;

public class ExpectedExceptionGenerator
extends TestCheckGenerator {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ThrowsClause>> exceptionSets;

    public ExpectedExceptionGenerator(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ThrowsClause>> exceptionSets) {
        this.exceptionSets = exceptionSets;
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TestChecks<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @Signed @SignednessBottom @SignatureUnknown @SignatureBottom ?> generateTestChecks(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSequence eseq) {
        int finalIndex = eseq.sequence.size() - 1;
        ExecutionOutcome result = eseq.getResult(finalIndex);
        if (result instanceof NotExecuted) {
            throw new Error("Abnormal execution in sequence: " + eseq);
        }
        if (result instanceof ExceptionalExecution) {
            ExceptionalExecution exec = (ExceptionalExecution)result;
            Throwable throwable = exec.getException();
            ClassOrInterfaceType throwableType = ClassOrInterfaceType.forClass(throwable.getClass());
            for (List<ThrowsClause> exceptionSet : this.exceptionSets) {
                ClassOrInterfaceType matchingType = ExpectedExceptionGenerator.findMatchingExpectedType(throwableType, exceptionSet);
                if (matchingType != null) continue;
                return this.getMissingExceptionTestChecks(finalIndex);
            }
            return new RegressionChecks(new ExpectedExceptionCheck(throwable, finalIndex, throwableType.getBinaryName()));
        }
        return this.getMissingExceptionTestChecks(finalIndex);
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType findMatchingExpectedType(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ClassOrInterfaceType throwableType, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ThrowsClause> throwsClauses) {
        for (ThrowsClause exception : throwsClauses) {
            ClassOrInterfaceType expected = exception.getExceptionType();
            if (!throwableType.isSubtypeOf(expected)) continue;
            return expected;
        }
        return null;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ErrorRevealingChecks getMissingExceptionTestChecks(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int finalIndex) {
        ErrorRevealingChecks checks = new ErrorRevealingChecks();
        checks.add(new MissingExceptionCheck(this.exceptionSets, finalIndex));
        return checks;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ThrowsClause>> getExpected() {
        return this.exceptionSets;
    }
}

