/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import java.text.Normalizer;
import randoop.Globals;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.PolyNull;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.plumelib.util.StringsPlume;
import randoop.test.ExceptionCheck;

public class ExpectedExceptionCheck
extends ExceptionCheck {
    public ExpectedExceptionCheck(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Throwable exception, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int statementIndex, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String catchClassName) {
        super(exception, statementIndex, catchClassName);
    }

    @Override
    protected void appendTryBehavior(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown StringBuilder b) {
        String message;
        if (this.exception.getClass().isAnonymousClass()) {
            message = "Expected anonymous exception";
        } else {
            String exceptionMessage;
            try {
                exceptionMessage = "; message: " + this.toAscii(this.exception.getMessage());
            }
            catch (Throwable t2) {
                exceptionMessage = " whose getMessage() throws an exception";
            }
            message = "Expected exception of type " + this.getExceptionName() + exceptionMessage;
        }
        String assertionMessage = StringsPlume.escapeJava(message);
        b.append(Globals.lineSep).append("  org.junit.Assert.fail(\"").append(assertionMessage).append("\");").append(Globals.lineSep);
    }

    private @PolyNull @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toAscii(@PolyNull @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String str) {
        if (str == null) {
            return null;
        }
        String normalized = Normalizer.normalize(str, Normalizer.Form.NFD);
        String ascii = normalized.replaceAll("[^ -~]", "?");
        return ascii;
    }

    @Override
    protected void appendCatchBehavior(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown StringBuilder b) {
        if (this.exception.getClass().isAnonymousClass()) {
            String condition = "e.getClass().isAnonymousClass()";
            String message = "Expected anonymous exception, got \" + e.getClass().getCanonicalName()";
            String assertion = "org.junit.Assert.fail(\"" + message + ")";
            b.append("  if (! ").append(condition).append(") {").append(Globals.lineSep);
            b.append("    ").append(assertion).append(";").append(Globals.lineSep);
            b.append("  }").append(Globals.lineSep);
        }
    }
}

