/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import randoop.contract.ObjectContract;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;

public class ContractSet {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ObjectContract>> contractMap = new ArrayList<List<ObjectContract>>(1);

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ObjectContract> getWithArity(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int arity) {
        List<ObjectContract> contractList = this.contractMap.get(arity);
        if (contractList == null) {
            contractList = new ArrayList<ObjectContract>();
        }
        return contractList;
    }

    public void add(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ObjectContract contract) {
        int arity = contract.getArity();
        while (arity >= this.contractMap.size()) {
            this.contractMap.add(new ArrayList(1));
        }
        List<ObjectContract> contractList = this.contractMap.get(arity);
        contractList.add(contract);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isEmpty() {
        return this.contractMap.isEmpty();
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        int cardinality = 0;
        StringJoiner contractString = new StringJoiner(System.lineSeparator());
        int size = this.contractMap.size();
        for (int i = 0; i < size; ++i) {
            List<ObjectContract> contractList = this.contractMap.get(i);
            if (contractList.isEmpty()) continue;
            contractString.add(String.format("    arity %d: %s", i, contractList));
            cardinality += contractList.size();
        }
        return String.format("ContractSet[size=%d]%n%s", cardinality, contractString.toString());
    }
}

