/*
 * Decompiled with CFR 0.152.
 */
package randoop.test;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import randoop.com.github.javaparser.ast.CompilationUnit;
import randoop.com.github.javaparser.ast.PackageDeclaration;
import randoop.compile.SequenceCompiler;
import randoop.main.GenTests;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.EnsuresCalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.mustcall.qual.Owning;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.output.JUnitCreator;
import randoop.output.NameGenerator;
import randoop.sequence.ExecutableSequence;
import randoop.util.Log;

@MustCall(value={"close"})
public class CompilableTestPredicate
implements Closeable,
Predicate<ExecutableSequence> {
    @Owning
    private final @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SequenceCompiler compiler;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown JUnitCreator junitCreator;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown NameGenerator classNameGenerator;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown NameGenerator methodNameGenerator;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GenTests genTests;

    public CompilableTestPredicate(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown JUnitCreator junitCreator, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown GenTests genTests) {
        ArrayList<String> compilerOptions = new ArrayList<String>(6);
        compilerOptions.add("-Xmaxerrs");
        compilerOptions.add("1");
        compilerOptions.add("-implicit:none");
        compilerOptions.add("-proc:none");
        compilerOptions.add("-g:none");
        compilerOptions.add("-Xlint:none");
        this.compiler = new SequenceCompiler(compilerOptions);
        this.junitCreator = junitCreator;
        this.classNameGenerator = new NameGenerator("RandoopTemporarySeqTest");
        this.methodNameGenerator = new NameGenerator("theSequence");
        this.genTests = genTests;
    }

    @Override
    @EnsuresCalledMethods(value={"compiler"}, methods={"close"})
    public void close() throws @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IOException {
        this.compiler.close();
    }

    @Override
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean test(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutableSequence eseq) {
        List<ExecutableSequence> sequences;
        String testClassName;
        CompilationUnit source;
        Optional<PackageDeclaration> oPkg = (source = this.junitCreator.createTestClass(testClassName = this.classNameGenerator.next(), this.methodNameGenerator, sequences = Collections.singletonList(eseq))).getPackageDeclaration();
        String packageName = oPkg.isPresent() ? oPkg.get().getName().toString() : null;
        boolean result = this.testSource(testClassName, source, packageName);
        if (!result) {
            this.genTests.incrementSequenceCompileFailureCount();
            Log.logPrintf("%nCompilableTestPredicate => false for%n%nsequence =%n%s%nsource =%n%s%n", eseq, source);
            if (SequenceCompiler.debugCompilationFailure != null && eseq.toCodeString().contains(SequenceCompiler.debugCompilationFailure)) {
                System.out.println("Compilation failure for:");
                System.out.println("package: " + packageName);
                System.out.println("test class: " + testClassName);
                System.out.println(source);
                System.out.println("sequence =");
                System.out.println(eseq);
            }
        }
        return result;
    }

    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean testSource(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String testClassName, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown CompilationUnit source, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String packageName) {
        String sourceText = source.toString();
        return this.compiler.isCompilable(packageName, testClassName, sourceText);
    }
}

