/*
 * Decompiled with CFR 0.152.
 */
package randoop.sequence;

import java.util.ArrayList;
import java.util.List;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.sequence.Sequence;
import randoop.sequence.Variable;
import randoop.types.Type;
import randoop.util.Randomness;
import randoop.util.SimpleList;

public final class TupleSequence {
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence sequence;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Integer> outputIndices;

    public TupleSequence(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> sequences, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Integer> variables) {
        assert (sequences.size() == variables.size()) : "must be one variable for each sequence";
        this.sequence = Sequence.concatenate(sequences);
        int sequencesSize = sequences.size();
        this.outputIndices = new ArrayList<Integer>(sequencesSize);
        int size = 0;
        for (int i = 0; i < sequencesSize; ++i) {
            this.outputIndices.add(size + variables.get(i));
            size += sequences.get(i).size();
        }
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Integer> getOutputIndices() {
        return this.outputIndices;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TupleSequence createElementsSequence(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown SimpleList<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> candidates, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int length, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Type elementType) {
        ArrayList<Sequence> sequences = new ArrayList<Sequence>(length);
        ArrayList<Integer> variables = new ArrayList<Integer>(length);
        for (int i = 0; i < length; ++i) {
            Sequence sequence = candidates.get(Randomness.nextRandomInt(candidates.size()));
            sequences.add(sequence);
            Variable element = sequence.randomVariableForTypeLastStatement(elementType, false);
            assert (element != null);
            variables.add(element.index);
        }
        return new TupleSequence(sequences, variables);
    }
}

