/*
 * Decompiled with CFR 0.152.
 */
package randoop.sequence;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import randoop.ExceptionalExecution;
import randoop.ExecutionOutcome;
import randoop.ExecutionVisitor;
import randoop.Globals;
import randoop.NormalExecution;
import randoop.NotExecuted;
import randoop.condition.ExpectedOutcomeTable;
import randoop.main.GenInputsAbstract;
import randoop.operation.TypedOperation;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import randoop.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import randoop.org.checkerframework.checker.nullness.qual.Nullable;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.org.checkerframework.dataflow.qual.Pure;
import randoop.org.checkerframework.dataflow.qual.SideEffectFree;
import randoop.sequence.Execution;
import randoop.sequence.ReferenceValue;
import randoop.sequence.Sequence;
import randoop.sequence.SequenceExecutionException;
import randoop.sequence.Statement;
import randoop.sequence.Value;
import randoop.sequence.Variable;
import randoop.test.Check;
import randoop.test.ExceptionCheck;
import randoop.test.InvalidChecks;
import randoop.test.InvalidValueCheck;
import randoop.test.TestCheckGenerator;
import randoop.test.TestChecks;
import randoop.types.ReferenceType;
import randoop.types.Type;
import randoop.util.IdentityMultiMap;
import randoop.util.Log;
import randoop.util.ProgressDisplay;

public class ExecutableSequence {
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence sequence;
    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @MonotonicNonNull @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TestChecks<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @Signed @SignednessBottom @SignatureUnknown @SignatureBottom ?> checks = null;
    private transient @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Execution executionResults;
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown long gentimeNanos = -1L;
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown long exectime = -1L;
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasNullInput = false;
    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ByteArrayOutputStream output_buffer = new ByteArrayOutputStream();
    private static @UnknownRegex @MustCall(value={"close"}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown PrintStream output_buffer_stream = new PrintStream(output_buffer);
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown IdentityMultiMap<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable> variableMap = new IdentityMultiMap();
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> componentSequences = Collections.emptyList();

    public ExecutableSequence(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence sequence) {
        this.sequence = sequence;
        this.executionResults = new Execution(sequence);
    }

    private void reset() {
        this.executionResults = new Execution(this.sequence);
        this.exectime = -1L;
        this.hasNullInput = false;
        this.variableMap = new IdentityMultiMap();
    }

    @SideEffectFree
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toString() {
        StringJoiner result = new StringJoiner(System.lineSeparator());
        for (int i = 0; i < this.sequence.size(); ++i) {
            StringBuilder b = new StringBuilder();
            this.sequence.appendCode(b, i);
            if (this.executionResults.size() > i) {
                b.append(" // ");
                b.append(this.executionResults.get(i).toString());
            }
            result.add(b.toString());
            if (i != this.sequence.size() - 1 || this.checks == null) continue;
            for (Check check : this.checks.checks()) {
                result.add(check.toString());
            }
        }
        return result.toString();
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String> toCodeLines() {
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < this.sequence.size(); ++i) {
            if (this.sequence.shouldInlineLiterals() && this.sequence.getStatement(i).getInlinedForm() != null && i < this.sequence.size() - 1) continue;
            StringBuilder oneStatement = new StringBuilder();
            this.sequence.appendCode(oneStatement, i);
            if (i == this.sequence.size() - 1 && this.checks != null) {
                ExceptionCheck exObs = this.checks.getExceptionCheck();
                if (exObs != null) {
                    oneStatement.insert(0, exObs.toCodeStringPreStatement());
                    oneStatement.append(exObs.toCodeStringPostStatement());
                }
                for (Check d : this.checks.checks()) {
                    oneStatement.insert(0, d.toCodeStringPreStatement());
                    oneStatement.append(Globals.lineSep).append(d.toCodeStringPostStatement());
                }
            }
            lines.add(oneStatement.toString());
        }
        return lines;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String toCodeString() {
        StringBuilder b = new StringBuilder();
        for (String line : this.toCodeLines()) {
            b.append(line).append(Globals.lineSep);
        }
        return b.toString();
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown String statementToCodeString(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int i) {
        StringBuilder oneStatement = new StringBuilder();
        this.sequence.appendCode(oneStatement, i);
        return oneStatement.toString();
    }

    public void execute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutionVisitor visitor, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TestCheckGenerator gen) {
        this.execute(visitor, gen, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutionVisitor visitor, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TestCheckGenerator gen, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean ignoreException) {
        long startTime = System.nanoTime();
        try {
            visitor.initialize(this);
            this.reset();
            for (int i = 0; i < this.sequence.size(); ++i) {
                TypedOperation operation;
                Object[] inputValues = this.getRuntimeInputs(this.executionResults.outcomes, this.sequence.getInputs(i));
                if (i == this.sequence.size() - 1 && ((operation = this.sequence.getStatement(i).getOperation()).isConstructorCall() || operation.isMethodCall())) {
                    ExpectedOutcomeTable outcomeTable = operation.checkPrestate(inputValues);
                    if (outcomeTable.isInvalidCall()) {
                        this.checks = new InvalidChecks(new InvalidValueCheck(this, i));
                        return;
                    }
                    gen = outcomeTable.addPostCheckGenerator(gen);
                }
                visitor.visitBeforeStatement(this, i);
                ExecutableSequence.executeStatement(this.sequence, this.executionResults.outcomes, i, inputValues);
                ExecutionOutcome statementResult = this.getResult(i);
                if (statementResult instanceof NotExecuted) {
                    throw new Error("Unexecuted statement in sequence: " + this.toString());
                }
                if (statementResult instanceof ExceptionalExecution && i < this.sequence.size() - 1) {
                    if (ignoreException) break;
                    Throwable e = ((ExceptionalExecution)statementResult).getException();
                    String msg = String.format("Exception before final statement%n  statement %d = %s, input = %s):%n  %s%n%s", i, this.sequence.getStatement(i), Arrays.toString(inputValues), e.getMessage() == null ? "[no detail message]" : e.getMessage(), this.sequence);
                    throw new Error(msg, e);
                }
                visitor.visitAfterStatement(this, i);
            }
            visitor.visitAfterSequence(this);
            if (Value.lastValueSizeOk(this)) {
                this.checks = gen.generateTestChecks(this);
            } else {
                Log.logPrintf("Excluding from generateTestChecks due to value too large in last statement%n", new Object[0]);
            }
        }
        finally {
            this.exectime = System.nanoTime() - startTime;
        }
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] getRuntimeInputs(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable> inputs) {
        return this.getRuntimeInputs(this.executionResults.outcomes, inputs);
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] getRuntimeInputs(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutionOutcome> outcome, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable> inputs) {
        Object[] ros;
        for (Object ro : ros = ExecutableSequence.getRuntimeValuesForVars(inputs, outcome)) {
            if (ro != null) continue;
            this.hasNullInput = true;
        }
        return ros;
    }

    public static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] getRuntimeValuesForVars(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable> vars, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Execution execution) {
        return ExecutableSequence.getRuntimeValuesForVars(vars, execution.outcomes);
    }

    private static @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] getRuntimeValuesForVars(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable> vars, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutionOutcome> execution) {
        Object[] runtimeObjects = new Object[vars.size()];
        for (int j = 0; j < runtimeObjects.length; ++j) {
            int creatingStatementIdx = vars.get(j).getDeclIndex();
            assert (execution.get(creatingStatementIdx) instanceof NormalExecution) : execution.get(creatingStatementIdx).getClass();
            NormalExecution ne = (NormalExecution)execution.get(creatingStatementIdx);
            runtimeObjects[j] = ne.getRuntimeValue();
        }
        return runtimeObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeStatement(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence s2, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutionOutcome> outcome, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int index, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown [] inputVariables) {
        Statement statement = s2.getStatement(index);
        Object object = ProgressDisplay.print_synchro;
        synchronized (object) {
            ExecutionOutcome r;
            PrintStream orig_out = System.out;
            PrintStream orig_err = System.err;
            if (GenInputsAbstract.capture_output) {
                System.out.flush();
                System.err.flush();
                System.setOut(output_buffer_stream);
                System.setErr(output_buffer_stream);
            }
            try {
                r = statement.execute(inputVariables);
            }
            catch (SequenceExecutionException e) {
                throw new SequenceExecutionException("Problem while executing " + statement, e);
            }
            finally {
                if (GenInputsAbstract.capture_output) {
                    System.setOut(orig_out);
                    System.setErr(orig_err);
                }
            }
            assert (r != null);
            if (GenInputsAbstract.capture_output) {
                output_buffer_stream.flush();
                String output_buffer_string = output_buffer.toString();
                r.set_output(output_buffer_string);
                output_buffer.reset();
            }
            outcome.set(index, r);
        }
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ExecutionOutcome getResult(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int index) {
        return this.executionResults.get(index);
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TestChecks<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @Signed @SignednessBottom @SignatureUnknown @SignatureBottom ?> getChecks() {
        return this.checks;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object getValue(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int index) {
        ExecutionOutcome result = this.getResult(index);
        if (result instanceof NormalExecution) {
            return ((NormalExecution)result).getRuntimeValue();
        }
        throw new Error("Abnormal execution in sequence: " + this);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceValue> getLastStatementValues() {
        LinkedHashSet<ReferenceValue> values = new LinkedHashSet<ReferenceValue>();
        Object outputValue = this.getValue(this.sequence.size() - 1);
        Variable outputVariable = this.sequence.getLastVariable();
        this.addReferenceValue(outputVariable, outputValue, values);
        for (Variable inputVariable : this.sequence.getInputs(this.sequence.size() - 1)) {
            Object inputValue = this.getValue(inputVariable.index);
            this.addReferenceValue(inputVariable, inputValue, values);
        }
        return new ArrayList<ReferenceValue>(values);
    }

    private void addReferenceValue(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable variable, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object value, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceValue> refValues) {
        Type type;
        if (value != null && (type = variable.getType()).isReferenceType() && !type.isString()) {
            refValues.add(new ReferenceValue((ReferenceType)type, value));
            this.variableMap.put(value, variable);
        }
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReferenceValue> getAllValues() {
        LinkedHashSet<ReferenceValue> values = new LinkedHashSet<ReferenceValue>();
        for (int i = 0; i < this.sequence.size() - 1; ++i) {
            Object value = this.getValue(i);
            if (value == null) continue;
            Variable variable = this.sequence.getVariable(i);
            this.addReferenceValue(variable, value, values);
        }
        return new ArrayList<ReferenceValue>(values);
    }

    public @Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable> getVariables(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object value) {
        Set<Variable> variables = this.variableMap.get(value);
        if (variables == null) {
            return null;
        }
        return new ArrayList<Variable>(variables);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Variable getVariable(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object value) {
        return this.variableMap.get(value).iterator().next();
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isNormalExecution(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int i) {
        return this.getResult(i) instanceof NormalExecution;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int getNonNormalExecutionIndex() {
        for (int i = 0; i < this.sequence.size(); ++i) {
            if (this.isNormalExecution(i)) continue;
            return i;
        }
        return -1;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean isNormalExecution() {
        return this.getNonNormalExecutionIndex() == -1;
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int getExceptionIndex(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> exceptionClass) {
        if (exceptionClass == null) {
            throw new IllegalArgumentException("exceptionClass<?> cannot be null");
        }
        for (int i = 0; i < this.sequence.size(); ++i) {
            ExceptionalExecution e;
            if (!(this.getResult(i) instanceof ExceptionalExecution) || !exceptionClass.isAssignableFrom((e = (ExceptionalExecution)this.getResult(i)).getException().getClass())) continue;
            return i;
        }
        return -1;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean throwsException(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> exceptionClass) {
        return this.getExceptionIndex(exceptionClass) >= 0;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasNonExecutedStatements() {
        return this.getNonExecutedIndex() != -1;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int getNonExecutedIndex() {
        for (int i = this.sequence.size() - 1; i >= 0; --i) {
            if (!(this.getResult(i) instanceof NotExecuted)) continue;
            return i;
        }
        return -1;
    }

    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int hashCode() {
        return Objects.hash(this.sequence.hashCode(), this.checks.hashCode());
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean equals(@Nullable @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExecutableSequence)) {
            return false;
        }
        ExecutableSequence that = (ExecutableSequence)obj;
        return this.sequence.equals(that.sequence) && Objects.equals(this.checks, that.checks);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasNullInput() {
        return this.hasNullInput;
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasFailure() {
        return this.checks != null && this.checks.hasErrorBehavior();
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean hasInvalidBehavior() {
        return this.checks != null && this.checks.hasInvalidBehavior();
    }

    public void addCoveredClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> c) {
        this.executionResults.addCoveredClass(c);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown boolean coversClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> c) {
        return this.executionResults.getCoveredClasses().contains(c);
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown TypedOperation getOperation() {
        return this.sequence.getOperation();
    }

    public @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown int size() {
        return this.sequence.size();
    }
}

