/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.reflection.AccessibilityPredicate;
import randoop.reflection.DefaultClassVisitor;
import randoop.reflection.ReflectionManager;
import randoop.types.ClassOrInterfaceType;
import randoop.types.ParameterizedType;
import randoop.types.PrimitiveType;
import randoop.util.Log;

class TypeExtractor
extends DefaultClassVisitor {
    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown randoop.types.Type> inputTypes;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate predicate;

    TypeExtractor(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown randoop.types.Type> inputTypes, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown AccessibilityPredicate predicate) {
        this.inputTypes = inputTypes;
        this.predicate = predicate;
    }

    @Override
    public void visit(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> c, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown ReflectionManager reflectionManager) {
        this.addIfConcrete(ClassOrInterfaceType.forClass(c));
        reflectionManager.apply(this, c);
    }

    @Override
    public void visit(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Constructor<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> c) {
        for (Type paramType : c.getGenericParameterTypes()) {
            this.addIfConcrete(randoop.types.Type.forType(paramType));
        }
    }

    @Override
    public void visit(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Method m4) {
        if (m4.isBridge()) {
            return;
        }
        for (Type paramType : m4.getGenericParameterTypes()) {
            this.addIfConcrete(randoop.types.Type.forType(paramType));
        }
        Type returnType = m4.getGenericReturnType();
        this.addIfConcrete(randoop.types.Type.forType(returnType));
    }

    @Override
    public void visit(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Field f) {
        Type fieldType = f.getGenericType();
        this.addIfConcrete(randoop.types.Type.forType(fieldType));
    }

    private void addIfConcrete(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown randoop.types.Type type) {
        if (!(type.isVoid() || type.isGeneric() || type.isParameterized() && ((ParameterizedType)type).hasWildcard())) {
            if (!this.predicate.isAccessible(type.getRuntimeClass())) {
                return;
            }
            if (type.isPrimitive()) {
                type = ((PrimitiveType)type).toBoxedPrimitive();
            }
            Log.logPrintf("Adding %s [%s] as candidate parameter type%n", type, type.getClass());
            this.inputTypes.add(type);
        }
    }

    @Override
    public void visitBefore(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> c) {
        if (c.getTypeParameters().length == 0) {
            this.inputTypes.add(ClassOrInterfaceType.forClass(c));
        }
    }
}

