/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import randoop.TestValue;
import randoop.generation.SeedSequences;
import randoop.main.GenInputsAbstract;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.common.value.qual.UnknownVal;
import randoop.reflection.DefaultClassVisitor;
import randoop.sequence.Sequence;

public class TestValueExtractor
extends DefaultClassVisitor {
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> valueSequences;

    public TestValueExtractor(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Set<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Sequence> valueSequences) {
        this.valueSequences = valueSequences;
    }

    @Override
    public void visit(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Field f) {
        if (f.getAnnotation(TestValue.class) != null) {
            if (!Modifier.isStatic(f.getModifiers())) {
                String msg = "RANDOOP ANNOTATION ERROR: Expected @TestValue-annotated field " + f.getName() + " in class " + f.getDeclaringClass() + " to be declared static but it was not.";
                throw new RuntimeException(msg);
            }
            this.valueSequences.addAll(SeedSequences.objectsToSeeds(this.getValue(f)));
        }
    }

    private @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown List<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object> getValue(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Field f) {
        List<Object> valueList;
        Class<?> fieldType = f.getType();
        if (fieldType.isPrimitive() || fieldType.equals(String.class) || fieldType.isArray() && (fieldType.getComponentType().isPrimitive() || fieldType.getComponentType().equals(String.class))) {
            Object value;
            if (GenInputsAbstract.progressdisplay) {
                TestValueExtractor.printDetectedAnnotatedFieldMsg(f);
            }
            f.setAccessible(true);
            try {
                value = f.get(null);
            }
            catch (IllegalAccessException e) {
                String msg = "RANDOOP ANNOTATION ERROR: IllegalAccessException when processing @TestValue-annotated field " + f.getName() + " in class " + f.getDeclaringClass() + ". (Is the class declaring this field publicly-accessible?)";
                throw new RuntimeException(msg);
            }
            if (!fieldType.isArray()) {
                valueList = Collections.singletonList(value);
            } else {
                int length = Array.getLength(value);
                valueList = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    valueList.add(Array.get(value, i));
                }
            }
        } else {
            String msg = "RANDOOP ANNOTATION ERROR: Expected @TestValue-annotated field " + f.getName() + " in class " + f.getDeclaringClass() + " to declare a primitive type, String, or an array of primitives of Strings, but the field's type is " + f.getType() + ".";
            throw new RuntimeException(msg);
        }
        return valueList;
    }

    private static void printDetectedAnnotatedFieldMsg(@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Field f) {
        String msg = "ANNOTATION: Detected @TestValue-annotated field " + f.getType().getCanonicalName() + " \"" + f.getName() + "\" in class " + f.getDeclaringClass().getCanonicalName() + ". Will collect its primitive values to use in generation.";
        System.out.println(msg);
    }
}

