/*
 * Decompiled with CFR 0.152.
 */
package randoop.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import randoop.main.RandoopBug;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethods;
import randoop.org.checkerframework.checker.calledmethods.qual.CalledMethodsBottom;
import randoop.org.checkerframework.checker.mustcall.qual.MustCall;
import randoop.org.checkerframework.checker.regex.qual.RegexBottom;
import randoop.org.checkerframework.checker.regex.qual.UnknownRegex;
import randoop.org.checkerframework.checker.signature.qual.SignatureBottom;
import randoop.org.checkerframework.checker.signature.qual.SignatureUnknown;
import randoop.org.checkerframework.checker.signedness.qual.Signed;
import randoop.org.checkerframework.checker.signedness.qual.SignednessBottom;
import randoop.org.checkerframework.checker.signedness.qual.UnknownSignedness;
import randoop.org.checkerframework.common.value.qual.BottomVal;
import randoop.org.checkerframework.common.value.qual.UnknownVal;

public class StaticCache {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> declaringClass;
    private final @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Map<@UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Field, @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Object> valueMap;

    public StaticCache(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @UnknownVal @Signed @SignatureUnknown Class<@UnknownRegex @RegexBottom @MustCall(value={}) @MustCall(value={}) @CalledMethods(value={}) @CalledMethodsBottom @UnknownVal @BottomVal @UnknownSignedness @SignednessBottom @SignatureUnknown @SignatureBottom ?> declaringClass) {
        this.declaringClass = declaringClass;
        this.valueMap = new LinkedHashMap<Field, Object>();
    }

    public void printCache() {
        for (Map.Entry<Field, Object> entry : this.valueMap.entrySet()) {
            System.out.println(this.declaringClass.getName() + "." + entry.getKey().getName() + " = " + entry.getValue());
        }
    }

    public void saveState() {
        for (Field field : this.declaringClass.getDeclaredFields()) {
            Object value;
            field.setAccessible(true);
            int mods = Modifier.fieldModifiers() & field.getModifiers();
            if (!Modifier.isStatic(mods) || Modifier.isFinal(mods)) continue;
            try {
                value = field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new RandoopBug("unable to save value of field " + field.getName());
            }
            this.valueMap.put(field, value);
        }
    }

    public void restoreState() {
        for (Map.Entry<Field, Object> entry : this.valueMap.entrySet()) {
            try {
                entry.getKey().set(null, entry.getValue());
            }
            catch (IllegalAccessException e) {
                throw new RandoopBug("unable to save value of field " + entry.getKey());
            }
        }
    }
}

